/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.jmx.reflect;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.sonatype.nexus.jmx.MBeanBuilder;
import org.sonatype.nexus.jmx.reflect.DescriptorHelper;
import org.sonatype.nexus.jmx.reflect.ManagedAttribute;
import org.sonatype.nexus.jmx.reflect.ManagedObject;
import org.sonatype.nexus.jmx.reflect.ManagedOperation;
import org.sonatype.nexus.jmx.reflect.ReflectionMBeanAttribute;
import org.sonatype.nexus.jmx.reflect.ReflectionMBeanOperation;

public class ReflectionMBeanBuilder
extends MBeanBuilder {
    private final Class<?> type;
    private Supplier target;

    public ReflectionMBeanBuilder(Class<?> type) {
        super(type.getName());
        this.type = type;
    }

    public ReflectionMBeanBuilder target(Supplier target) {
        this.target = target;
        return this;
    }

    public ReflectionMBeanBuilder discover() throws Exception {
        Preconditions.checkNotNull((Object)this.target);
        this.log.debug("Discovering managed members of type: {}", this.type);
        ManagedObject managedDescriptor = this.type.getAnnotation(ManagedObject.class);
        Preconditions.checkNotNull((Object)managedDescriptor);
        HashMap attributeBuilders = Maps.newHashMap();
        Method[] methodArray = this.type.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (!method.isBridge() && !method.isSynthetic()) {
                this.log.trace("Scanning for managed annotations on method: {}", (Object)method);
                ManagedAttribute attributeDescriptor = method.getAnnotation(ManagedAttribute.class);
                ManagedOperation operationDescriptor = method.getAnnotation(ManagedOperation.class);
                if (attributeDescriptor != null || operationDescriptor != null) {
                    String name;
                    if (attributeDescriptor != null && operationDescriptor != null) {
                        this.log.warn("Confusing managed annotations on method: {}", (Object)method);
                    } else if (attributeDescriptor != null) {
                        this.log.trace("Processing attribute descriptor: {}", (Object)attributeDescriptor);
                        name = Strings.emptyToNull((String)attributeDescriptor.name());
                        if (name == null) {
                            name = ReflectionMBeanBuilder.attributeName(method);
                        }
                        boolean getter = ReflectionMBeanBuilder.isGetter(method);
                        boolean setter = ReflectionMBeanBuilder.isSetter(method);
                        if (name == null || !getter && !setter) {
                            this.log.warn("Invalid attribute getter or setter method: {}", (Object)method);
                        } else {
                            ReflectionMBeanAttribute.Builder builder = (ReflectionMBeanAttribute.Builder)((Object)attributeBuilders.get(name));
                            if (builder == null) {
                                builder = new ReflectionMBeanAttribute.Builder().name(name).target(this.target);
                                attributeBuilders.put(name, builder);
                            }
                            if (Strings.emptyToNull((String)attributeDescriptor.description()) != null) {
                                builder.description(attributeDescriptor.description());
                            }
                            if (getter) {
                                this.log.debug("Found attribute getter: {} -> {}", (Object)name, (Object)method);
                                builder.getter(method);
                            } else {
                                this.log.debug("Found attribute setter: {} -> {}", (Object)name, (Object)method);
                                builder.setter(method);
                            }
                        }
                    } else {
                        this.log.trace("Processing operation descriptor: {}", (Object)operationDescriptor);
                        name = Strings.emptyToNull((String)operationDescriptor.name());
                        if (name == null) {
                            name = method.getName();
                        }
                        this.log.debug("Found operation: {} -> {}", (Object)name, (Object)method);
                        this.operation(new ReflectionMBeanOperation.Builder().name(name).target(this.target).impact(operationDescriptor.impact()).description(Strings.emptyToNull((String)operationDescriptor.description())).method(method).build());
                    }
                }
            }
            ++n2;
        }
        for (ReflectionMBeanAttribute.Builder builder : attributeBuilders.values()) {
            this.attribute(builder.build());
        }
        this.descriptor(DescriptorHelper.build(this.type));
        return this;
    }

    private static boolean isSetter(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getReturnType().equals(Void.TYPE);
    }

    private static boolean isGetter(Method method) {
        String name = method.getName();
        return (name.startsWith("get") || name.startsWith("is")) && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE);
    }

    @Nullable
    private static String attributeName(Method method) {
        String name = method.getName();
        if (name.startsWith("is")) {
            return name.substring(2, name.length());
        }
        if (name.startsWith("get") || name.startsWith("set")) {
            return name.substring(3, name.length());
        }
        return null;
    }
}

