/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.internal.blobstore.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;
import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.repository.blobstore.BlobStoreConfigurationStore;
import org.sonatype.nexus.repository.internal.blobstore.orient.OrientBlobStoreConfiguration;
import org.sonatype.nexus.repository.internal.blobstore.orient.OrientBlobStoreConfigurationEntityAdapter;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientBlobStoreConfigurationStore
extends StateGuardLifecycleSupport
implements BlobStoreConfigurationStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientBlobStoreConfigurationEntityAdapter entityAdapter;

    @Inject
    public OrientBlobStoreConfigurationStore(@Named(value="config") Provider<DatabaseInstance> databaseInstance, OrientBlobStoreConfigurationEntityAdapter entityAdapter) {
        this.databaseInstance = databaseInstance;
        this.entityAdapter = entityAdapter;
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<BlobStoreConfiguration> list() {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)this.entityAdapter.browse(db)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void create(BlobStoreConfiguration configuration) {
        this.checkBlobStoreConfiguration(configuration);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.addEntity(db, (Entity)((OrientBlobStoreConfiguration)configuration));
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public void update(BlobStoreConfiguration configuration) {
        this.checkBlobStoreConfiguration(configuration);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            boolean bl = this.entityAdapter.update(db, (OrientBlobStoreConfiguration)configuration);
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public void delete(BlobStoreConfiguration configuration) {
        this.checkBlobStoreConfiguration(configuration);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> this.entityAdapter.deleteEntity(db, (Entity)((OrientBlobStoreConfiguration)configuration)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public BlobStoreConfiguration read(String name) {
        return (BlobStoreConfiguration)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getByName(db, name));
    }

    @Override
    @Guarded(by={"STARTED"})
    public Optional<BlobStoreConfiguration> findParent(String name) {
        return (Optional)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getParent(db, name));
    }

    @Override
    public BlobStoreConfiguration newConfiguration() {
        return this.entityAdapter.newEntity();
    }

    private void checkBlobStoreConfiguration(BlobStoreConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkArgument((boolean)(configuration instanceof OrientBlobStoreConfiguration), (Object)"Not an instance of OrientBlobStoreConfiguration");
    }
}

