/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.internal.blobstore;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreLocator;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.api.RepositoryDoesNotExistException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
@Singleton
public class BlobStoreLocatorImpl
implements BlobStoreLocator {
    private final BlobStoreManager blobStoreManager;
    private final RepositoryManager repositoryManager;

    @Inject
    public BlobStoreLocatorImpl(BlobStoreManager blobStoreManager, RepositoryManager repositoryManager) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    public BlobStore getBlobStore(String repositoryName) throws RepositoryDoesNotExistException {
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository == null) {
            throw new RepositoryDoesNotExistException();
        }
        Configuration configuration = repository.getConfiguration();
        String blobStoreName = (String)configuration.attributes("storage").require("blobStoreName", String.class);
        return this.blobStoreManager.get(blobStoreName);
    }
}

