/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.internal.blobstore;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.group.BlobStoreGroupConfigurationHelper;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.blobstore.BlobStoreConfigurationStore;
import org.sonatype.nexus.repository.internal.blobstore.BlobStoreConfigurationDAO;
import org.sonatype.nexus.repository.internal.blobstore.BlobStoreConfigurationData;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class BlobStoreConfigurationStoreImpl
extends ConfigStoreSupport<BlobStoreConfigurationDAO>
implements BlobStoreConfigurationStore {
    @Inject
    public BlobStoreConfigurationStoreImpl(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Override
    public BlobStoreConfiguration newConfiguration() {
        return new BlobStoreConfigurationData();
    }

    @Override
    @Transactional
    public List<BlobStoreConfiguration> list() {
        return ImmutableList.copyOf((Iterable)((BlobStoreConfigurationDAO)this.dao()).browse());
    }

    @Override
    @Transactional
    public void create(BlobStoreConfiguration configuration) {
        ((BlobStoreConfigurationDAO)this.dao()).create((BlobStoreConfigurationData)configuration);
    }

    @Override
    @Transactional
    public BlobStoreConfiguration read(String name) {
        return ((BlobStoreConfigurationDAO)this.dao()).readByName(name).orElse(null);
    }

    @Override
    @Transactional
    public void update(BlobStoreConfiguration configuration) {
        ((BlobStoreConfigurationDAO)this.dao()).update((BlobStoreConfigurationData)configuration);
    }

    @Override
    @Transactional
    public void delete(BlobStoreConfiguration configuration) {
        ((BlobStoreConfigurationDAO)this.dao()).deleteByName(configuration.getName());
    }

    @Override
    @Transactional
    public Optional<BlobStoreConfiguration> findParent(String name) {
        return ((BlobStoreConfigurationDAO)this.dao()).findCandidateParents(name).stream().filter(config -> BlobStoreGroupConfigurationHelper.memberNames((BlobStoreConfiguration)config).contains(name)).findFirst();
    }
}

