/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.internal.blobstore;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.entity.HasEntityId;
import org.sonatype.nexus.common.entity.HasName;

public class BlobStoreConfigurationData
implements HasEntityId,
HasName,
BlobStoreConfiguration {
    private static final String STATE = "state";
    private static final String WRITABLE = "writable";
    @JsonIgnore
    private EntityId id;
    private String name;
    private String type;
    private Map<String, Map<String, Object>> attributes;
    private static final ObjectMapper MAPPER = BlobStoreConfigurationData.makeObjectMapper();

    public EntityId getId() {
        return this.id;
    }

    public void setId(EntityId id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, Map<String, Object>> getAttributes() {
        if (this.attributes == null) {
            this.attributes = Maps.newHashMap();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, Map<String, Object>> attributes) {
        this.attributes = attributes;
    }

    public NestedAttributesMap attributes(String key) {
        HashMap map;
        Preconditions.checkNotNull((Object)key);
        if (this.attributes == null) {
            this.attributes = Maps.newHashMap();
        }
        if ((map = this.attributes.get(key)) == null) {
            map = Maps.newHashMap();
            this.attributes.put(key, map);
        }
        return new NestedAttributesMap(key, (Map)map);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", attributes=" + this.attributes + '}';
    }

    private static ObjectMapper makeObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public BlobStoreConfiguration copy(String name) {
        BlobStoreConfigurationData clone = new BlobStoreConfigurationData();
        clone.setName(name);
        clone.setType(this.getType());
        if (this.attributes != null && this.attributes.size() > 0) {
            Map clonedAttributes;
            String attribsJson;
            try {
                attribsJson = MAPPER.writer().writeValueAsString(this.getAttributes());
            }
            catch (JsonProcessingException e) {
                throw new BlobStoreException("failed to marshal blob store configuration attributes to JSON", (Throwable)e, null);
            }
            try {
                clonedAttributes = (Map)MAPPER.readValue(attribsJson, (TypeReference)new TypeReference<Map<String, Map<String, Object>>>(){});
            }
            catch (IOException e) {
                throw new BlobStoreException("failed to parse blob store configuration attributes from JSON", (Throwable)e, null);
            }
            clone.setAttributes(clonedAttributes);
        }
        return clone;
    }

    public boolean isWritable() {
        return Optional.ofNullable(this.attributes).map(a -> (Map)a.get(STATE)).map(a -> a.get(WRITABLE)).map(Boolean.class::cast).orElse(Boolean.TRUE);
    }

    public void setWritable(boolean writable) {
        this.attributes(STATE).set(WRITABLE, (Object)writable);
    }
}

