/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.config;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.ConstraintValidatorContext;
import org.sonatype.nexus.repository.config.UniqueRepositoryName;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.validation.ConstraintValidatorSupport;

@Named
public class UniqueRepositoryNameValidator
extends ConstraintValidatorSupport<UniqueRepositoryName, String> {
    private final RepositoryManager repositoryManager;

    @Inject
    public UniqueRepositoryNameValidator(RepositoryManager repositoryManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        return !this.repositoryManager.exists(value);
    }
}

