/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationStore;
import org.sonatype.nexus.repository.config.internal.ConfigurationData;
import org.sonatype.nexus.repository.routing.RoutingRule;
import org.sonatype.nexus.repository.routing.RoutingRuleStore;
import org.sonatype.nexus.repository.routing.internal.RoutingRuleData;
import org.sonatype.nexus.supportzip.ExportConfigData;
import org.sonatype.nexus.supportzip.ImportData;
import org.sonatype.nexus.supportzip.datastore.JsonExporter;

@Named(value="configurationExport")
@Singleton
public class ConfigurationExport
extends JsonExporter
implements ExportConfigData,
ImportData {
    private final ConfigurationStore configurationStore;
    private final RoutingRuleStore routingRuleStore;

    @Inject
    public ConfigurationExport(ConfigurationStore configurationStore, RoutingRuleStore routingRuleStore) {
        this.configurationStore = (ConfigurationStore)Preconditions.checkNotNull((Object)configurationStore);
        this.routingRuleStore = (RoutingRuleStore)Preconditions.checkNotNull((Object)routingRuleStore);
    }

    public void export(File file) throws IOException {
        this.log.debug("Export Configuration and RoutingRule data to {}", (Object)file);
        List<Configuration> configurations = this.configurationStore.list();
        List<RoutingRule> routingRules = this.routingRuleStore.list();
        Map<String, RoutingRule> routingRuleById = routingRules.stream().collect(Collectors.toMap(routing -> routing.id().getValue(), routing -> routing));
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        for (Configuration configuration : configurations) {
            Repository repository = new Repository();
            repository.setConfiguration(configuration);
            if (configuration.getRoutingRuleId() != null) {
                String routingRuleId = configuration.getRoutingRuleId().getValue();
                repository.setRoutingRule(routingRuleById.get(routingRuleId));
            }
            repositories.add(repository);
        }
        Set configRoutingRules = configurations.stream().filter(config -> config.getRoutingRuleId() != null).map(config -> config.getRoutingRuleId().getValue()).collect(Collectors.toSet());
        List routingRulesWithoutRepo = routingRules.stream().filter(routingRule -> !configRoutingRules.contains(routingRule.id().getValue())).collect(Collectors.toList());
        for (RoutingRule routingRule2 : routingRulesWithoutRepo) {
            Repository repository = new Repository();
            repository.setRoutingRule(routingRule2);
            repositories.add(repository);
        }
        this.exportToJson(repositories, file);
    }

    public void restore(File file) throws IOException {
        this.log.debug("Restoring Configuration and RoutingRule data from {}", (Object)file);
        List repositories = this.importFromJson(file, Repository.class);
        for (Repository repository : repositories) {
            Configuration configuration = repository.getConfiguration();
            RoutingRule routingRule = repository.getRoutingRule();
            if (configuration != null) {
                this.saveConfiguration(configuration, routingRule);
            }
            if (configuration != null || routingRule == null) continue;
            ((RoutingRuleData)routingRule).setId(null);
            this.routingRuleStore.create(routingRule);
        }
    }

    private void saveConfiguration(Configuration configuration, RoutingRule routingRule) {
        if (routingRule instanceof RoutingRuleData) {
            ((RoutingRuleData)routingRule).setId(null);
            RoutingRule storedRoutingRule = this.routingRuleStore.getByName(routingRule.name());
            if (storedRoutingRule != null) {
                configuration.setRoutingRuleId(storedRoutingRule.id());
            } else {
                RoutingRule newRoutingRule = this.routingRuleStore.create(routingRule);
                configuration.setRoutingRuleId(newRoutingRule.id());
            }
        }
        this.configurationStore.create(configuration);
    }

    public static class Repository {
        @JsonProperty
        @JsonDeserialize(as=ConfigurationData.class)
        private Configuration configuration;
        @JsonProperty
        @JsonDeserialize(as=RoutingRuleData.class)
        private RoutingRule routingRule;

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(Configuration configuration) {
            this.configuration = configuration;
        }

        public RoutingRule getRoutingRule() {
            return this.routingRule;
        }

        public void setRoutingRule(RoutingRule routingRule) {
            this.routingRule = routingRule;
        }
    }
}

