/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.MultipleFailures;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.scheduling.TaskInterruptedException;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
public abstract class RepositoryTaskSupport
extends TaskSupport {
    public static final String REPOSITORY_NAME_FIELD_ID = "repositoryName";
    public static final String ALL_REPOSITORIES = "*";
    private RepositoryManager repositoryManager;
    private Type groupType;
    private Set<Repository> processedRepositories;

    @Inject
    public void install(RepositoryManager repositoryManager, @Named(value="group") Type groupType) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.groupType = (Type)Preconditions.checkNotNull((Object)groupType, (Object)"repository group type required");
    }

    protected Object execute() throws Exception {
        this.processedRepositories = Sets.newHashSet();
        MultipleFailures failures = new MultipleFailures();
        for (Repository repository : this.findRepositories()) {
            if (this.isCanceled()) break;
            try {
                this.execute(repository);
            }
            catch (TaskInterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("Failed to run task '{}' on repository '{}'", new Object[]{this.getMessage(), repository.getName(), e});
                failures.add((Throwable)e);
            }
        }
        failures.maybePropagate(String.format("Failed to run task '%s'", this.getMessage()));
        return null;
    }

    @Nonnull
    private Iterable<Repository> findRepositories() {
        String repositoryName = this.getRepositoryField();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)repositoryName) ? 1 : 0) != 0);
        if (ALL_REPOSITORIES.equals(repositoryName)) {
            return Iterables.filter(this.repositoryManager.browse(), this::appliesTo);
        }
        if (repositoryName.contains(",")) {
            String[] repositoryNames = repositoryName.split(",");
            if (Arrays.asList(repositoryNames).contains(ALL_REPOSITORIES)) {
                return Iterables.filter(this.repositoryManager.browse(), this::appliesTo);
            }
            return Arrays.stream(repositoryNames).map(this.repositoryManager::get).filter(this::appliesTo).collect(Collectors.toList());
        }
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository == null) {
            this.log.warn("Repository '{}' was not found while running task '{}'", (Object)repositoryName, (Object)this.getMessage());
            throw new TaskInterruptedException(String.format("Repository '%s' was not found.", repositoryName), true);
        }
        Preconditions.checkState((boolean)this.appliesTo(repository));
        return ImmutableList.of((Object)repository);
    }

    protected String getRepositoryField() {
        return this.getConfiguration().getString(REPOSITORY_NAME_FIELD_ID);
    }

    protected boolean isGroupRepository(Repository repository) {
        return this.groupType.equals(repository.getType());
    }

    protected void markProcessed(Repository repository) {
        this.processedRepositories.add(repository);
    }

    protected boolean hasBeenProcessed(Repository repository) {
        return this.processedRepositories.contains(repository);
    }

    protected abstract void execute(Repository var1);

    protected abstract boolean appliesTo(Repository var1);
}

