/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventBus;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuard;
import org.sonatype.nexus.common.stateguard.StateGuardAware;
import org.sonatype.nexus.common.stateguard.Transitions;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.MissingFacetException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;

public abstract class FacetSupport
extends ComponentSupport
implements Facet,
StateGuardAware {
    private EventManager eventManager;
    private Repository repository;
    protected final StateGuard states = new StateGuard.Builder().logger(this.createLogger()).initial("NEW").failure("FAILED").create();

    @Inject
    public void installDependencies(EventManager eventManager) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    protected EventManager getEventManager() {
        return (EventManager)Preconditions.checkNotNull((Object)this.eventManager);
    }

    protected Repository getRepository() {
        return (Repository)Preconditions.checkNotNull((Object)this.repository);
    }

    @Nonnull
    public StateGuard getStateGuard() {
        return this.states;
    }

    @Override
    @Transitions(from={"NEW"}, to="ATTACHED")
    public void attach(Repository repository) throws Exception {
        this.repository = (Repository)Preconditions.checkNotNull((Object)repository);
    }

    @Override
    @Guarded(by={"ATTACHED", "STARTED", "STOPPED"})
    public void validate(Configuration configuration) throws Exception {
        this.doValidate(configuration);
    }

    protected void doValidate(Configuration configuration) throws Exception {
    }

    protected void doConfigure(Configuration configuration) throws Exception {
    }

    @Override
    @Transitions(from={"ATTACHED"}, to="INITIALISED")
    public void init() throws Exception {
        this.doInit(this.getRepository().getConfiguration());
    }

    protected void doInit(Configuration configuration) throws Exception {
        this.doConfigure(configuration);
    }

    @Override
    @Guarded(by={"STOPPED"})
    public void update() throws Exception {
        this.doUpdate(this.getRepository().getConfiguration());
    }

    protected void doUpdate(Configuration configuration) throws Exception {
        this.doConfigure(configuration);
    }

    @Override
    @Transitions(from={"INITIALISED", "STOPPED"}, to="STARTED")
    public void start() throws Exception {
        this.doStart();
        this.eventManager.register((Object)this);
    }

    protected void doStart() throws Exception {
    }

    @Override
    @Transitions(from={"STARTED"}, to="STOPPED")
    public void stop() throws Exception {
        this.eventManager.unregister((Object)this);
        this.doStop();
    }

    protected void doStop() throws Exception {
    }

    @Override
    @Transitions(from={"STOPPED"}, to="DELETED")
    public void delete() throws Exception {
        this.doDelete();
    }

    protected void doDelete() throws Exception {
    }

    @Override
    @Transitions(to="DESTROYED")
    public void destroy() throws Exception {
        if (this.states.is("STARTED")) {
            this.stop();
        }
        this.doDestroy();
        this.repository = null;
    }

    protected void doDestroy() throws Exception {
    }

    @Nonnull
    protected <T extends Facet> T facet(Class<T> type) throws MissingFacetException {
        return this.getRepository().facet(type);
    }

    @Nonnull
    protected <T extends Facet> Optional<T> optionalFacet(Class<T> type) {
        return this.getRepository().optionalFacet(type);
    }

    @Deprecated
    protected EventBus getEventBus() {
        return this.eventManager;
    }

    public static final class State {
        public static final String NEW = "NEW";
        public static final String ATTACHED = "ATTACHED";
        public static final String INITIALISED = "INITIALISED";
        public static final String STARTED = "STARTED";
        public static final String STOPPED = "STOPPED";
        public static final String DELETED = "DELETED";
        public static final String DESTROYED = "DESTROYED";
        public static final String FAILED = "FAILED";
    }
}

