/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore.orient;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.api.BlobStoreUsageChecker;
import org.sonatype.nexus.blobstore.restore.RestoreBlobStrategy;
import org.sonatype.nexus.blobstore.restore.orient.OrientIntegrityCheckStrategy;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maintenance.MaintenanceService;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketStore;
import org.sonatype.nexus.repository.types.GroupType;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
public class OrientRestoreMetadataTask
extends TaskSupport
implements Cancelable {
    private final BlobStoreManager blobStoreManager;
    private final RepositoryManager repositoryManager;
    private final Map<String, RestoreBlobStrategy> restoreBlobStrategies;
    private final Map<String, OrientIntegrityCheckStrategy> integrityCheckStrategies;
    private final BlobStoreUsageChecker blobStoreUsageChecker;
    private final DryRunPrefix dryRunPrefix;
    private final OrientIntegrityCheckStrategy defaultOrientIntegrityCheckStrategy;
    private final BucketStore bucketStore;
    private final MaintenanceService maintenanceService;

    @Inject
    public OrientRestoreMetadataTask(BlobStoreManager blobStoreManager, RepositoryManager repositoryManager, Map<String, RestoreBlobStrategy> restoreBlobStrategies, BlobStoreUsageChecker blobStoreUsageChecker, DryRunPrefix dryRunPrefix, Map<String, OrientIntegrityCheckStrategy> integrityCheckStrategies, BucketStore bucketStore, MaintenanceService maintenanceService) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.restoreBlobStrategies = (Map)Preconditions.checkNotNull(restoreBlobStrategies);
        this.blobStoreUsageChecker = (BlobStoreUsageChecker)Preconditions.checkNotNull((Object)blobStoreUsageChecker);
        this.dryRunPrefix = (DryRunPrefix)Preconditions.checkNotNull((Object)dryRunPrefix);
        this.defaultOrientIntegrityCheckStrategy = (OrientIntegrityCheckStrategy)Preconditions.checkNotNull((Object)integrityCheckStrategies.get("default"));
        this.integrityCheckStrategies = (Map)Preconditions.checkNotNull(integrityCheckStrategies);
        this.bucketStore = (BucketStore)Preconditions.checkNotNull((Object)bucketStore);
        this.maintenanceService = (MaintenanceService)Preconditions.checkNotNull((Object)maintenanceService);
    }

    public String getMessage() {
        return null;
    }

    protected Void execute() throws Exception {
        String blobStoreId = (String)Preconditions.checkNotNull((Object)this.getConfiguration().getString("blobstoreName"));
        boolean dryRun = this.getConfiguration().getBoolean("dryRun", false);
        boolean restoreBlobs = this.getConfiguration().getBoolean("restoreBlobs", false);
        boolean undeleteBlobs = this.getConfiguration().getBoolean("undeleteBlobs", false);
        boolean integrityCheck = this.getConfiguration().getBoolean("integrityCheck", false);
        Integer sinceDays = this.getConfiguration().getInteger("sinceDays", -1);
        this.restore(blobStoreId, restoreBlobs, undeleteBlobs, dryRun, sinceDays);
        this.blobStoreIntegrityCheck(integrityCheck, blobStoreId);
        return null;
    }

    private void restore(String blobStoreName, boolean restore, boolean undelete, boolean dryRun, Integer sinceDays) {
        if (!restore && !undelete) {
            this.log.warn("No repair/restore operations selected");
            return;
        }
        String logPrefix = dryRun ? this.dryRunPrefix.get() : "";
        BlobStore store = this.blobStoreManager.get(blobStoreName);
        long processed = 0L;
        long undeleted = 0L;
        boolean updateAssets = !dryRun && restore;
        HashSet<Repository> touchedRepositories = new HashSet<Repository>();
        if (dryRun) {
            this.log.info("{}Actions will be logged, but no changes will be made.", (Object)logPrefix);
        }
        Throwable throwable = null;
        Object var15_14 = null;
        try (ProgressLogIntervalHelper progressLogger = new ProgressLogIntervalHelper(this.log, 60);){
            for (BlobId blobId : this.getBlobIdStream(store, sinceDays)) {
                try {
                    Optional<Context> context = this.buildContext(blobStoreName, store, blobId);
                    if (context.isPresent()) {
                        Context c = context.get();
                        if (restore && c.restoreBlobStrategy != null && !c.blobAttributes.isDeleted()) {
                            c.restoreBlobStrategy.restore(c.properties, c.blob, c.blobStore, dryRun);
                        }
                        if (undelete && store.undelete(this.blobStoreUsageChecker, c.blobId, c.blobAttributes, dryRun)) {
                            ++undeleted;
                        }
                        if (updateAssets) {
                            touchedRepositories.add(c.repository);
                        }
                    }
                    progressLogger.info("{}Elapsed time: {}, processed: {}, un-deleted: {}", new Object[]{logPrefix, progressLogger.getElapsed(), ++processed, undeleted});
                    if (!this.isCanceled()) continue;
                    break;
                }
                catch (Exception e) {
                    this.log.error("Error restoring blob {}", (Object)blobId, (Object)e);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.updateAssets(touchedRepositories, updateAssets);
    }

    private Iterable<BlobId> getBlobIdStream(BlobStore store, Integer sinceDays) {
        if (Objects.isNull(sinceDays) || sinceDays < 0) {
            this.log.info("Will process all blobs");
            return store.getBlobIdStream()::iterator;
        }
        return store.getBlobIdUpdatedSinceStream(sinceDays.intValue())::iterator;
    }

    private void updateAssets(Set<Repository> repositories, boolean updateAssets) {
        for (Repository repository : repositories) {
            if (this.isCanceled()) break;
            Optional.ofNullable(this.restoreBlobStrategies.get(repository.getFormat().getValue())).ifPresent(strategy -> strategy.after(updateAssets, repository));
        }
    }

    private void blobStoreIntegrityCheck(boolean integrityCheck, String blobStoreId) {
        if (!integrityCheck) {
            this.log.warn("Integrity check operation not selected");
            return;
        }
        BlobStore blobStore = this.blobStoreManager.get(blobStoreId);
        if (blobStore == null) {
            this.log.error("Unable to find blob store '{}' in the blob store manager", (Object)blobStoreId);
            return;
        }
        Iterable repositories = this.repositoryManager.browseForBlobStore(blobStoreId);
        List syncList = Collections.synchronizedList(StreamSupport.stream(repositories.spliterator(), false).collect(Collectors.toList()));
        syncList.stream().filter(Objects::nonNull).filter(r -> !(r.getType() instanceof GroupType)).filter(Repository::isStarted).forEach(repository -> this.integrityCheckStrategies.getOrDefault(repository.getFormat().getValue(), this.defaultOrientIntegrityCheckStrategy).check((Repository)repository, blobStore, () -> ((OrientRestoreMetadataTask)this).isCanceled(), this::integrityCheckFailedHandler));
    }

    protected void integrityCheckFailedHandler(Asset asset) {
        Bucket bucket = this.bucketStore.getById(asset.bucketId());
        Repository repository = this.repositoryManager.get(bucket.getRepositoryName());
        this.log.info("Removing asset {} from repository {}, blob integrity check failed", (Object)asset.name(), (Object)repository.getName());
        boolean dryRun = this.getConfiguration().getBoolean("dryRun", false);
        if (!dryRun) {
            this.maintenanceService.deleteAsset(repository, asset);
        }
    }

    private Optional<Context> buildContext(String blobStoreName, BlobStore blobStore, BlobId blobId) {
        return Optional.of(new Context(blobStoreName, blobStore, blobId)).map(context -> context.blob(context.blobStore.get(context.blobId, true))).map(context -> context.blobAttributes(context.blobStore.getBlobAttributes(context.blobId))).map(context -> context.properties(context.blobAttributes.getProperties())).map(context -> context.repositoryName(context.properties.getProperty("@Bucket.repo-name"))).map(context -> context.repository(this.repositoryManager.get(context.repositoryName))).map(context -> context.restoreBlobStrategy(this.restoreBlobStrategies.get(context.repository.getFormat().getValue())));
    }

    private static class Context {
        final String blobStoreName;
        final BlobStore blobStore;
        final BlobId blobId;
        Blob blob;
        BlobAttributes blobAttributes;
        Properties properties;
        String repositoryName;
        Repository repository;
        RestoreBlobStrategy restoreBlobStrategy;

        Context(String blobStoreName, BlobStore blobStore, BlobId blobId) {
            this.blobStoreName = (String)Preconditions.checkNotNull((Object)blobStoreName);
            this.blobStore = (BlobStore)Preconditions.checkNotNull((Object)blobStore);
            this.blobId = (BlobId)Preconditions.checkNotNull((Object)blobId);
        }

        Context blob(Blob blob) {
            if (blob == null) {
                return null;
            }
            this.blob = blob;
            return this;
        }

        Context blobAttributes(BlobAttributes blobAttributes) {
            if (blobAttributes == null) {
                return null;
            }
            this.blobAttributes = blobAttributes;
            return this;
        }

        Context properties(Properties properties) {
            if (properties == null) {
                return null;
            }
            this.properties = properties;
            return this;
        }

        Context repositoryName(String repositoryName) {
            if (repositoryName == null) {
                return null;
            }
            this.repositoryName = repositoryName;
            return this;
        }

        Context repository(Repository repository) {
            if (repository == null) {
                return null;
            }
            this.repository = repository;
            return this;
        }

        Context restoreBlobStrategy(RestoreBlobStrategy restoreBlobStrategy) {
            this.restoreBlobStrategy = restoreBlobStrategy;
            return this;
        }
    }
}

