/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.blobstore.restore.RestoreBlobDataSupport;
import org.sonatype.nexus.blobstore.restore.RestoreBlobStrategy;
import org.sonatype.nexus.blobstore.restore.orient.OrientRestoreBlobData;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.hash.Hashes;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

public abstract class OrientBaseRestoreBlobStrategy<T extends RestoreBlobDataSupport>
extends ComponentSupport
implements RestoreBlobStrategy {
    private NodeAccess nodeAccess;
    private RepositoryManager repositoryManager;
    private BlobStoreManager blobStoreManager;
    private DryRunPrefix dryRunPrefix;

    public OrientBaseRestoreBlobStrategy(NodeAccess nodeAccess, RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, DryRunPrefix dryRunPrefix) {
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.dryRunPrefix = (DryRunPrefix)Preconditions.checkNotNull((Object)dryRunPrefix);
    }

    @Override
    public void restore(Properties properties, Blob blob, BlobStore blobStore, boolean isDryRun) {
        OrientRestoreBlobData blobData = new OrientRestoreBlobData(blob, properties, blobStore, this.repositoryManager);
        Optional storageFacet = blobData.getRepository().optionalFacet(StorageFacet.class);
        T restoreData = this.createRestoreData(blobData);
        if (storageFacet.isPresent() && this.canAttemptRestore(restoreData)) {
            this.doRestore((StorageFacet)storageFacet.get(), blobData, restoreData, isDryRun);
        } else {
            this.log.info("Skipping asset, blob store: {}, repository: {}, blob name: {}, blob id: {}", new Object[]{blobStore.getBlobStoreConfiguration().getName(), blobData.getRepository().getName(), ((RestoreBlobData)blobData).getBlobName(), blob.getId()});
        }
    }

    private void doRestore(StorageFacet storageFacet, RestoreBlobData blobData, T restoreData, boolean isDryRun) {
        String logPrefix = isDryRun ? this.dryRunPrefix.get() : "";
        String path = this.getAssetPath(restoreData);
        String blobStoreName = blobData.getBlobStore().getBlobStoreConfiguration().getName();
        String repoName = blobData.getRepository().getName();
        String blobName = blobData.getBlobName();
        Blob blob = blobData.getBlob();
        UnitOfWork.begin((Supplier)storageFacet.txSupplier());
        try {
            if (this.isBlobDeleted(blobData)) {
                this.log.info("Skipping soft-deleted asset for blob store: {}, repository: {}, blob name: {}, blob id: {}", new Object[]{blobStoreName, repoName, blobName, blob.getId()});
                return;
            }
            if (this.assetExists(restoreData)) {
                if (this.shouldDeleteAsset(restoreData, blobData, path)) {
                    this.log.info("{} Associated component is required but not found; deleting asset - blob store: {}, repository: {}, path: {}, blob name: {}, blob id: {}", new Object[]{logPrefix, blobStoreName, repoName, path, blobName, blob.getId()});
                    if (!isDryRun) {
                        this.deleteAsset(blobData.getRepository(), path);
                    }
                } else if (this.isRestoreDataMoreRecent(restoreData, path)) {
                    this.log.info("{} Deleting asset as more recent blob will be restored for blob store: {}, repository: {}, path: {}, blob name: {}, blob id: {}", new Object[]{logPrefix, blobStoreName, repoName, path, blobName, blob.getId()});
                    if (!isDryRun) {
                        this.deleteAsset(blobData.getRepository(), path);
                    }
                } else {
                    this.log.info("Skipping as asset already exists, blob store: {}, repository: {}, path: {}, blob name: {}, blob id: {}", new Object[]{blobStoreName, repoName, path, blobName, blob.getId()});
                    return;
                }
            }
            try {
                if (!isDryRun) {
                    this.doCreateAssetFromBlob(blobData, restoreData, blob);
                }
                this.log.info("{}Restored asset, blob store: {}, repository: {}, path: {}, blob name: {}, blob id: {}", new Object[]{logPrefix, blobStoreName, repoName, path, blobName, blob.getId()});
            }
            catch (Exception e) {
                this.log.error("Error while restoring asset: blob store: {}, repository: {}, path: {}, blob name: {}, blob id: {}", new Object[]{blobStoreName, repoName, path, blobName, blob.getId(), e});
            }
        }
        finally {
            UnitOfWork.end();
        }
    }

    @TransactionalStoreMetadata
    protected void doCreateAssetFromBlob(RestoreBlobData blobData, T restoreData, Blob blob) throws IOException {
        List<HashAlgorithm> hashTypes = this.getHashAlgorithms();
        AssetBlob assetBlob = new AssetBlob(this.nodeAccess, blobData.getBlobStore(), blobStore -> blob, blobData.getProperty("@BlobStore.content-type"), Hashes.hash(hashTypes, (InputStream)blob.getInputStream()), true);
        this.createAssetFromBlob(assetBlob, restoreData);
    }

    @TransactionalDeleteBlob
    protected void deleteAsset(Repository repository, String assetName) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.findAsset(repository, assetName);
        if (asset != null) {
            tx.deleteAsset(asset, false);
        }
    }

    private boolean assetIsAssociatedWithComponent(T data, Repository repository, String name) throws IOException {
        Optional<EntityId> componentEntityId = this.componentEntityId(data);
        return componentEntityId.isPresent() && componentEntityId.equals(this.assetComponentEntityId(repository, name));
    }

    @Transactional
    protected Asset findAsset(Repository repository, String name) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return tx.findAssetWithProperty("name", (Object)name, tx.findBucket(repository));
    }

    @Transactional
    protected Optional<Component> findComponent(T data) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return Optional.ofNullable(this.getComponentQuery(data)).map(q -> (Component)Iterables.getFirst((Iterable)tx.findComponents(q, Collections.singletonList(this.getRepository(data))), null));
    }

    @Nonnull
    protected List<HashAlgorithm> getHashAlgorithms() {
        return Lists.newArrayList((Object[])new HashAlgorithm[]{HashAlgorithm.SHA1});
    }

    protected boolean shouldDeleteAsset(T restoreData, RestoreBlobData blobData, String path) throws IOException {
        return this.componentRequired(restoreData) && !this.assetIsAssociatedWithComponent(restoreData, blobData.getRepository(), path);
    }

    private Optional<EntityId> assetComponentEntityId(Repository repository, String name) {
        return Optional.ofNullable(this.findAsset(repository, name)).map(Asset::componentId);
    }

    private Optional<EntityId> componentEntityId(T data) throws IOException {
        return this.findComponent(data).map(Entity::getEntityMetadata).map(EntityMetadata::getId);
    }

    protected abstract T createRestoreData(RestoreBlobData var1);

    protected abstract boolean canAttemptRestore(@Nonnull T var1);

    protected abstract String getAssetPath(@Nonnull T var1);

    protected abstract boolean assetExists(@Nonnull T var1) throws IOException;

    @TransactionalTouchMetadata
    protected boolean isBlobDeleted(@Nonnull RestoreBlobData data) {
        return data.getRepository().optionalFacet(StorageFacet.class).map(StorageFacet::blobStore).map(blobStore -> blobStore.getBlobAttributes(data.getBlob().getId()).isDeleted()).orElse(true);
    }

    @TransactionalTouchMetadata
    protected boolean isRestoreDataMoreRecent(T restoreData, String path) {
        DateTime existingBlob;
        Asset asset = this.findAsset(((RestoreBlobDataSupport)restoreData).getBlobData().getRepository(), path);
        if (asset != null && (existingBlob = asset.blobCreated()) != null) {
            DateTime restoredBlob = ((RestoreBlobDataSupport)restoreData).getBlobData().getBlob().getMetrics().getCreationTime();
            return existingBlob.isBefore((ReadableInstant)restoredBlob);
        }
        return false;
    }

    protected boolean componentRequired(T data) throws IOException {
        return false;
    }

    protected Query getComponentQuery(T data) throws IOException {
        return null;
    }

    protected abstract Repository getRepository(@Nonnull T var1);

    protected abstract void createAssetFromBlob(@Nonnull AssetBlob var1, @Nonnull T var2) throws IOException;

    @Override
    public void after(boolean updateAssets, Repository repository) {
    }
}

