/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore.orient;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Priority;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobMetrics;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.restore.orient.OrientIntegrityCheckStrategy;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Priority(value=0x7FFFFFFF)
@Named(value="default")
@Singleton
public class DefaultOrientIntegrityCheckStrategy
extends ComponentSupport
implements OrientIntegrityCheckStrategy {
    public static final String NAME_MISMATCH = "Name does not match on asset! Metadata name: '{}', Blob name: '{}'";
    public static final String DEFAULT_NAME = "default";
    static final String BLOB_PROPERTIES_MISSING_FOR_ASSET = "Blob properties missing for asset '{}'.";
    static final String BLOB_DATA_MISSING_FOR_ASSET = "Blob data missing for asset '{}'.";
    static final String BLOB_PROPERTIES_MARKED_AS_DELETED = "Blob properties marked as deleted for asset '{}'. Will be removed on next compact.";
    static final String SHA1_MISMATCH = "SHA1 does not match on asset '{}'! Metadata SHA1: '{}', Blob SHA1: '{}'";
    static final String ASSET_SHA1_MISSING = "Asset is missing SHA1 hash code";
    static final String ASSET_NAME_MISSING = "Asset is missing name";
    static final String BLOB_NAME_MISSING = "Blob properties is missing name";
    static final String ERROR_ACCESSING_BLOB = "Error accessing blob for asset '{}'. Exception: {}";
    static final String ERROR_PROCESSING_ASSET = "Error processing asset '{}'";
    static final String ERROR_PROCESSING_ASSET_WITH_EX = "Error processing asset '{}'. Exception: {}";
    static final String CANCEL_WARNING = "Cancelling blob integrity check";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void check(Repository repository, BlobStore blobStore, Supplier<Boolean> isCancelled, Consumer<Asset> integrityCheckFailedHandler) {
        this.log.info("Checking integrity of assets in repository '{}' with blob store '{}'", (Object)repository.getName(), (Object)blobStore.getBlobStoreConfiguration().getName());
        long processed = 0L;
        long failedCounter = 0L;
        Throwable throwable = null;
        Object var10_9 = null;
        try {
            boolean failed;
            Asset asset;
            ProgressLogIntervalHelper progressLogger;
            block19: {
                Iterator<Asset> iterator;
                block18: {
                    progressLogger = new ProgressLogIntervalHelper(this.log, 60);
                    iterator = this.getAssets(repository).iterator();
                    finally {
                        if (iterator.hasNext()) break block18;
                        return;
                    }
                }
                asset = iterator.next();
                failed = false;
                try {
                    if (isCancelled.get().booleanValue()) {
                        this.log.warn(CANCEL_WARNING);
                        return;
                    }
                }
                catch (IllegalStateException e) {
                    this.log.error(ERROR_ACCESSING_BLOB, new Object[]{asset.toString(), e.getMessage(), this.log.isDebugEnabled() ? e : null});
                    failed = true;
                    break block19;
                }
                catch (IllegalArgumentException e) {
                    this.log.error(ERROR_PROCESSING_ASSET_WITH_EX, new Object[]{asset.toString(), e.getMessage(), this.log.isDebugEnabled() ? e : null});
                    failed = true;
                    break block19;
                }
                catch (Exception e) {
                    this.log.error(ERROR_PROCESSING_ASSET, (Object)asset.toString(), (Object)e);
                    failed = true;
                    break block19;
                }
                {
                    this.log.debug("checking asset {}", (Object)asset);
                    BlobRef blobRef = asset.requireBlobRef();
                    BlobId blobId = blobRef.getBlobId();
                    BlobAttributes blobAttributes = blobStore.getBlobAttributes(blobId);
                    if (blobAttributes == null) {
                        this.log.error(BLOB_PROPERTIES_MISSING_FOR_ASSET, (Object)asset.name());
                        failed = true;
                        break block19;
                    }
                    if (blobAttributes.isDeleted()) {
                        this.log.warn(BLOB_PROPERTIES_MARKED_AS_DELETED, (Object)asset.name());
                        failed = true;
                        break block19;
                    }
                    if (!this.blobDataExists(blobStore.get(blobId))) {
                        this.log.error(BLOB_DATA_MISSING_FOR_ASSET, (Object)asset.name());
                        failed = true;
                        break block19;
                    }
                    if (this.checkAsset(blobAttributes, asset)) break block19;
                    failed = true;
                }
            }
            if (failed) {
                ++failedCounter;
                if (integrityCheckFailedHandler != null) {
                    integrityCheckFailedHandler.accept(asset);
                }
            }
            progressLogger.info("Elapsed time: {}, processed: {}, failed integrity check: {}", new Object[]{progressLogger.getElapsed(), ++processed, failedCounter});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    protected boolean checkAsset(BlobAttributes blobAttributes, Asset asset) {
        Preconditions.checkArgument((blobAttributes.getProperties() != null ? 1 : 0) != 0, (Object)"Blob attributes are missing properties");
        return this.checkSha1(blobAttributes, asset) && this.checkName(blobAttributes, asset);
    }

    private boolean checkSha1(BlobAttributes blobAttributes, Asset asset) {
        String blobSha1;
        String assetSha1 = this.getAssetSha1(asset);
        if (!Objects.equals(assetSha1, blobSha1 = this.getBlobSha1(blobAttributes))) {
            this.log.error(SHA1_MISMATCH, new Object[]{asset.name(), assetSha1, blobSha1});
            return false;
        }
        return true;
    }

    protected String getBlobSha1(BlobAttributes blobAttributes) {
        BlobMetrics metrics = blobAttributes.getMetrics();
        Preconditions.checkArgument((metrics != null ? 1 : 0) != 0, (Object)"Blob attributes are missing metrics");
        String blobSha1 = metrics.getSha1Hash();
        Preconditions.checkArgument((blobSha1 != null ? 1 : 0) != 0, (Object)"Blob metrics are missing SHA1 hash code");
        return blobSha1;
    }

    protected String getAssetSha1(Asset asset) {
        HashCode assetSha1HashCode = asset.getChecksum(HashAlgorithm.SHA1);
        Preconditions.checkArgument((assetSha1HashCode != null ? 1 : 0) != 0, (Object)ASSET_SHA1_MISSING);
        return assetSha1HashCode.toString();
    }

    private boolean checkName(BlobAttributes blobAttributes, Asset asset) {
        String assetName = this.getAssetName(asset);
        String blobName = this.getBlobName(blobAttributes);
        Preconditions.checkArgument((blobName != null ? 1 : 0) != 0, (Object)BLOB_NAME_MISSING);
        Preconditions.checkArgument((assetName != null ? 1 : 0) != 0, (Object)ASSET_NAME_MISSING);
        if (blobName.startsWith("/") && !assetName.startsWith("/")) {
            blobName = blobName.substring(1);
        }
        if (!Objects.equals(assetName, blobName)) {
            this.log.error(NAME_MISMATCH, (Object)blobName, (Object)assetName);
            return false;
        }
        return true;
    }

    protected boolean blobDataExists(Blob blob) {
        try {
            blob.getInputStream().close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String getBlobName(BlobAttributes blobAttributes) {
        return blobAttributes.getProperties().getProperty("@BlobStore.blob-name");
    }

    protected String getAssetName(Asset asset) {
        return asset.name();
    }

    protected Iterable<Asset> getAssets(Repository repository) {
        return (Iterable)Transactional.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).call(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            return tx.browseAssets(tx.findBucket(repository));
        });
    }
}

