/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore.datastore;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobMetrics;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.restore.datastore.IntegrityCheckStrategy;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;

@Named(value="default")
@Singleton
public class DefaultIntegrityCheckStrategy
extends ComponentSupport
implements IntegrityCheckStrategy {
    public static final String NAME_MISMATCH = "Name does not match on asset! Metadata name: '{}', Blob name: '{}'";
    public static final String DEFAULT_NAME = "default";
    static final String BLOB_PROPERTIES_MISSING_FOR_ASSET = "Blob properties missing for asset '{}'.";
    static final String BLOB_DATA_MISSING_FOR_ASSET = "Blob data missing for asset '{}'.";
    static final String BLOB_PROPERTIES_MARKED_AS_DELETED = "Blob properties marked as deleted for asset '{}'. Will be removed on next compact.";
    static final String SHA1_MISMATCH = "SHA1 does not match on asset '{}'! Metadata SHA1: '{}', Blob SHA1: '{}'";
    static final String ASSET_SHA1_MISSING = "Asset is missing SHA1 hash code";
    static final String BLOB_NAME_MISSING = "Blob properties is missing name";
    static final String ERROR_ACCESSING_BLOB = "Error accessing blob for asset '{}'";
    static final String ASSET_NAME_MISSING = "Asset is missing name";
    static final String ERROR_PROCESSING_ASSET = "Error processing asset '{}'";
    static final String ERROR_PROCESSING_ASSET_WITH_EX = "Error processing asset '{}'. {} Exception: {}";
    static final String CANCEL_WARNING = "Cancelling blob integrity check";
    static final String BLOB_METRICS_MISSING_SHA1 = "Blob metrics are missing SHA1 hash code";
    static final String ASSET_INTEGRITY_CHECK_FAILED = "Asset integrity check failed for {}";
    private final int browseBatchSize;

    @Inject
    public DefaultIntegrityCheckStrategy(@Named(value="${nexus.blobstore.restore.integrityCheck.batchSize:-1000}") int browseBatchSize) {
        Preconditions.checkArgument((browseBatchSize > 0 ? 1 : 0) != 0);
        this.browseBatchSize = browseBatchSize;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void check(Repository repository, BlobStore blobStore, BooleanSupplier isCancelled, @Nullable Consumer<Asset> integrityCheckFailedHandler) {
        this.log.info("Checking integrity of assets in repository '{}' with blob store '{}'", (Object)repository.getName(), (Object)blobStore.getBlobStoreConfiguration().getName());
        processed = 0L;
        failures = 0L;
        var9_7 = null;
        var10_9 = null;
        try {
            progressLogger = new ProgressLogIntervalHelper(this.log, 60);
            try {
                fluentAssets = ((ContentFacet)repository.facet(ContentFacet.class)).assets();
                assets = fluentAssets.browse(this.browseBatchSize, null);
                while (true) {
                    for (FluentAsset asset : assets) {
                        if (isCancelled.getAsBoolean()) {
                            this.log.warn("Cancelling blob integrity check");
                            return;
                        }
                        this.log.debug("Checking asset {}", (Object)asset.path());
                        failed = this.checkAsset((Asset)asset, blobStore);
                        if (failed) {
                            ++failures;
                            if (integrityCheckFailedHandler != null) {
                                integrityCheckFailedHandler.accept((Asset)asset);
                            }
                        }
                        progressLogger.info("Elapsed time: {}, processed: {}, failed integrity check: {}", new Object[]{progressLogger.getElapsed(), ++processed, failures});
                    }
                    assets = fluentAssets.browse(this.browseBatchSize, assets.nextContinuationToken());
                    break;
                }
            }
            finally {
                if (!assets.isEmpty()) ** continue;
            }
        }
        catch (Throwable var10_10) {
            if (var9_7 == null) {
                var9_7 = var10_10;
            } else if (var9_7 != var10_10) {
                var9_7.addSuppressed(var10_10);
            }
            throw var9_7;
        }
    }

    private boolean checkAsset(Asset asset, BlobStore blobStore) {
        BlobAttributes blobAttributes;
        block11: {
            Optional<BlobId> blobId;
            block10: {
                block9: {
                    block8: {
                        blobId = asset.blob().map(AssetBlob::blobRef).map(BlobRef::getBlobId);
                        if (blobId.isPresent()) break block8;
                        this.log.error(ERROR_ACCESSING_BLOB, (Object)asset.path());
                        return true;
                    }
                    blobAttributes = blobStore.getBlobAttributes(blobId.get());
                    if (blobAttributes != null) break block9;
                    this.log.error(BLOB_PROPERTIES_MISSING_FOR_ASSET, (Object)asset.path());
                    return true;
                }
                if (!blobAttributes.isDeleted()) break block10;
                this.log.warn(BLOB_PROPERTIES_MARKED_AS_DELETED, (Object)asset.path());
                return true;
            }
            if (this.blobDataExists(blobStore.get(blobId.get()))) break block11;
            this.log.error(BLOB_DATA_MISSING_FOR_ASSET, (Object)asset.path());
            return true;
        }
        try {
            if (!this.checkAssetIntegrity(blobAttributes, asset)) {
                this.log.error(ASSET_INTEGRITY_CHECK_FAILED, (Object)asset.path());
                return true;
            }
            return false;
        }
        catch (IllegalArgumentException e) {
            this.log.error(ERROR_PROCESSING_ASSET_WITH_EX, new Object[]{asset.toString(), e.getMessage(), this.log.isDebugEnabled() ? e : null});
            return true;
        }
        catch (Exception e) {
            this.log.error(ERROR_PROCESSING_ASSET, (Object)asset.toString(), (Object)e);
            return true;
        }
    }

    protected boolean checkAssetIntegrity(BlobAttributes blobAttributes, Asset asset) {
        Preconditions.checkArgument((blobAttributes.getProperties() != null ? 1 : 0) != 0, (Object)"Blob attributes are missing properties");
        return this.checkSha1(blobAttributes, asset) && this.checkName(blobAttributes, asset);
    }

    private boolean checkSha1(BlobAttributes blobAttributes, Asset asset) {
        String blobSha1;
        String assetSha1 = this.getAssetSha1(asset);
        if (!Objects.equals(assetSha1, blobSha1 = this.getBlobSha1(blobAttributes))) {
            this.log.error(SHA1_MISMATCH, new Object[]{asset.path(), assetSha1, blobSha1});
            return false;
        }
        return true;
    }

    protected String getBlobSha1(BlobAttributes blobAttributes) {
        BlobMetrics metrics = blobAttributes.getMetrics();
        Preconditions.checkArgument((metrics != null ? 1 : 0) != 0, (Object)"Blob attributes are missing metrics");
        String blobSha1 = metrics.getSha1Hash();
        Preconditions.checkArgument((blobSha1 != null ? 1 : 0) != 0, (Object)BLOB_METRICS_MISSING_SHA1);
        return blobSha1;
    }

    protected String getAssetSha1(Asset asset) {
        return asset.blob().map(assetBlob -> (String)assetBlob.checksums().get(HashAlgorithm.SHA1.name())).orElseThrow(() -> new IllegalArgumentException(ASSET_SHA1_MISSING));
    }

    private boolean checkName(BlobAttributes blobAttributes, Asset asset) {
        String blobName = this.getBlobName(blobAttributes);
        String assetName = this.getAssetName(asset);
        Preconditions.checkArgument((blobName != null ? 1 : 0) != 0, (Object)BLOB_NAME_MISSING);
        Preconditions.checkArgument((assetName != null ? 1 : 0) != 0, (Object)ASSET_NAME_MISSING);
        if (!StringUtils.equals((String)assetName, (String)blobName)) {
            this.log.error(NAME_MISMATCH, (Object)blobName, (Object)assetName);
            return false;
        }
        return true;
    }

    protected boolean blobDataExists(Blob blob) {
        try {
            blob.getInputStream().close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String getAssetName(Asset asset) {
        return asset.path();
    }

    protected String getBlobName(BlobAttributes blobAttributes) {
        return blobAttributes.getProperties().getProperty("@BlobStore.blob-name");
    }
}

