/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore.datastore;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.blobstore.restore.RestoreBlobStrategy;
import org.sonatype.nexus.blobstore.restore.datastore.DataStoreRestoreBlobData;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;

public abstract class BaseRestoreBlobStrategy<T extends DataStoreRestoreBlobData>
extends ComponentSupport
implements RestoreBlobStrategy {
    private static final String ASSET_PATH_PREFIX = "/";
    private final DryRunPrefix dryRunPrefix;

    protected BaseRestoreBlobStrategy(DryRunPrefix dryRunPrefix) {
        this.dryRunPrefix = (DryRunPrefix)Preconditions.checkNotNull((Object)dryRunPrefix);
    }

    @Override
    public void restore(Properties properties, Blob blob, BlobStore blobStore, boolean isDryRun) {
        String logPrefix = isDryRun ? this.dryRunPrefix.get() : "";
        T restoreData = this.createRestoreData(properties, blob, blobStore);
        String repoName = ((RestoreBlobData)restoreData).getRepository().getName();
        String blobName = ((DataStoreRestoreBlobData)restoreData).getBlobName();
        String blobStoreName = blobStore.getBlobStoreConfiguration().getName();
        if (!this.canAttemptRestore(restoreData)) {
            this.log.info("Skipping asset for blob store: {}, repository: {}, blob name: {}, blob id: {}", new Object[]{blobStoreName, repoName, blobName, blob.getId()});
            return;
        }
        if (this.isDeleted(restoreData, blobStore)) {
            this.log.info("Skipping soft-deleted asset for blob store: {}, repository: {}, blob name: {}, blob id: {}", new Object[]{blobStoreName, repoName, blobName, blob.getId()});
            return;
        }
        String assetPath = StringUtils.prependIfMissing((String)this.getAssetPath(restoreData), (CharSequence)ASSET_PATH_PREFIX, (CharSequence[])new CharSequence[0]);
        try {
            Optional asset = ((ContentFacet)((RestoreBlobData)restoreData).getRepository().facet(ContentFacet.class)).assets().path(assetPath).find();
            if (asset.isPresent()) {
                FluentAsset fluentAsset = (FluentAsset)asset.get();
                if (this.shouldDeleteAsset(restoreData, fluentAsset)) {
                    this.log.info("{} Deleting asset as component is required but is not found, blob store: {}, repository: {}, path: {}, blob name: {}, blob id: {}", new Object[]{logPrefix, blobStoreName, repoName, fluentAsset.path(), blobName, blob.getId()});
                    if (!isDryRun) {
                        fluentAsset.delete();
                    }
                } else if (this.isRestoreDataMoreRecent(restoreData, fluentAsset)) {
                    this.log.info("{} Deleting asset as more recent blob will be restored, blob store: {}, repository: {}, path: {}, blob name: {}, blob id: {}", new Object[]{logPrefix, blobStoreName, repoName, fluentAsset.path(), blobName, blob.getId()});
                    if (!isDryRun) {
                        fluentAsset.delete();
                    }
                } else {
                    this.log.info("Skipping as asset already exists, blob store: {}, repository: {}, path: {}, blob name: {}, blob id: {}", new Object[]{blobStoreName, repoName, fluentAsset.path(), blobName, blob.getId()});
                    return;
                }
            }
            if (!isDryRun) {
                this.createAssetFromBlob(blob, restoreData);
            }
            this.log.info("{} Restored asset, blob store: {}, repository: {}, path: {}, blob name: {}, blob id: {}", new Object[]{logPrefix, blobStoreName, repoName, assetPath, blobName, blob.getId()});
        }
        catch (Exception ex) {
            this.log.error("Error while restoring asset: blob store: {}, repository: {}, path: {}, blob name: {}, blob id: {}", new Object[]{blobStoreName, repoName, assetPath, blobName, blob.getId(), ex});
        }
    }

    protected abstract boolean canAttemptRestore(@Nonnull T var1);

    protected abstract void createAssetFromBlob(Blob var1, T var2) throws IOException;

    protected boolean shouldDeleteAsset(T restoreData, FluentAsset asset) {
        return this.isComponentRequired(restoreData) && this.isOrphanedAsset(restoreData, asset);
    }

    protected boolean isRestoreDataMoreRecent(T restoreData, FluentAsset asset) {
        return asset.blob().map(AssetBlob::blobCreated).map(blobCreated -> {
            DateTime dateTime = restoreData.getBlob().getMetrics().getCreationTime();
            Instant instant = Instant.ofEpochMilli(dateTime.getMillis());
            OffsetDateTime restoredBlob = OffsetDateTime.ofInstant(instant, ZoneId.of(dateTime.getZone().getID()));
            return blobCreated.isBefore(restoredBlob);
        }).orElse(false);
    }

    protected boolean isDeleted(T restoreData, BlobStore blobStore) {
        BlobId blobId = ((RestoreBlobData)restoreData).getBlob().getId();
        BlobAttributes blobAttributes = blobStore.getBlobAttributes(blobId);
        if (blobAttributes != null) {
            return blobAttributes.isDeleted();
        }
        return true;
    }

    private boolean isOrphanedAsset(T data, FluentAsset asset) {
        return !asset.component().isPresent();
    }

    protected abstract String getAssetPath(@Nonnull T var1);

    protected abstract T createRestoreData(Properties var1, Blob var2, BlobStore var3);

    protected abstract boolean isComponentRequired(T var1);
}

