/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore;

import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.formfields.CheckboxFormField;
import org.sonatype.nexus.formfields.ComboboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.NumberTextFormField;
import org.sonatype.nexus.scheduling.TaskDescriptorSupport;
import org.sonatype.nexus.scheduling.TaskSupport;

public abstract class BaseRestoreMetadataTaskDescriptor
extends TaskDescriptorSupport {
    public static final String TYPE_ID = "blobstore.rebuildComponentDB";
    public static final String BLOB_STORE_NAME_FIELD_ID = "blobstoreName";
    public static final String RESTORE_BLOBS = "restoreBlobs";
    public static final String UNDELETE_BLOBS = "undeleteBlobs";
    public static final String INTEGRITY_CHECK = "integrityCheck";
    public static final String DRY_RUN = "dryRun";
    public static final String SINCE_DAYS = "sinceDays";
    private static final Messages messages = (Messages)I18N.create(Messages.class);

    public BaseRestoreMetadataTaskDescriptor(Class<? extends TaskSupport> restoreMetadataTaskClass) {
        super(TYPE_ID, restoreMetadataTaskClass, messages.name(), true, true, new FormField[]{new ComboboxFormField(BLOB_STORE_NAME_FIELD_ID, messages.blobstoreNameLabel(), messages.blobstoreNameHelpText(), true).withStoreApi("coreui_Blobstore.read").withIdMapping("name"), new CheckboxFormField(DRY_RUN, messages.dryRunLabel(), messages.dryRunHelpText(), false).withInitialValue(Boolean.valueOf(false)), new NumberTextFormField(SINCE_DAYS, messages.sinceDaysLabel(), messages.sinceDaysHelpText(), false).withMinimumValue((Number)0), new CheckboxFormField(RESTORE_BLOBS, messages.restoreBlobsLabel(), messages.restoreBlobsHelpText(), false).withInitialValue(Boolean.valueOf(true)), new CheckboxFormField(UNDELETE_BLOBS, messages.undeleteBlobsLabel(), messages.undeleteBlobsHelpText(), false).withInitialValue(Boolean.valueOf(true)), new CheckboxFormField(INTEGRITY_CHECK, messages.integrityCheckLabel(), messages.integrityCheckHelpText(), false).withInitialValue(Boolean.valueOf(true))});
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Repair - Reconcile component database from blob store")
        public String name();

        @MessageBundle.DefaultMessage(value="Blob store")
        public String blobstoreNameLabel();

        @MessageBundle.DefaultMessage(value="Select the blob store to restore")
        public String blobstoreNameHelpText();

        @MessageBundle.DefaultMessage(value="Restore blob metadata")
        public String restoreBlobsLabel();

        @MessageBundle.DefaultMessage(value="Restore missing metadata for blobs found in the blob store")
        public String restoreBlobsHelpText();

        @MessageBundle.DefaultMessage(value="Un-delete referenced blobs")
        public String undeleteBlobsLabel();

        @MessageBundle.DefaultMessage(value="Un-delete blobs which still have metadata referencing them")
        public String undeleteBlobsHelpText();

        @MessageBundle.DefaultMessage(value="Dry Run")
        public String dryRunLabel();

        @MessageBundle.DefaultMessage(value="Log actions, but make no changes.")
        public String dryRunHelpText();

        @MessageBundle.DefaultMessage(value="Integrity check")
        public String integrityCheckLabel();

        @MessageBundle.DefaultMessage(value="Verify integrity between asset metadata and blob properties")
        public String integrityCheckHelpText();

        @MessageBundle.DefaultMessage(value="Only blobs created since X days ago")
        public String sinceDaysLabel();

        @MessageBundle.DefaultMessage(value="Attempt to reconcile blobs only created within specified last number of days (inclusive). Leave empty to reconcile all blobs (this may take a very long time to finish)")
        public String sinceDaysHelpText();
    }
}

