/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.internal.orient;

import com.codahale.metrics.annotation.Timed;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreUsageChecker;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.orient.DatabaseInstance;

@Named
@Singleton
@Priority(value=0x7FFFFFFF)
@FeatureFlag(name="nexus.orient.enabled")
public class OrientFileBlobStoreUsageChecker
implements BlobStoreUsageChecker {
    private static final String ANY_NODE = "%";
    private final OSQLSynchQuery<ODocument> assetBlobRefQuery = new OSQLSynchQuery("SELECT FROM asset WHERE name = ? AND blob_ref LIKE ? LIMIT 1");
    private final Supplier<ODatabaseDocumentTx> txSupplier = () -> ((DatabaseInstance)databaseInstanceProvider.get()).acquire();

    @Inject
    public OrientFileBlobStoreUsageChecker(@Named(value="component") Provider<DatabaseInstance> databaseInstanceProvider) {
    }

    @Timed
    public boolean test(BlobStore blobStore, BlobId blobId, String blobName) {
        BlobRef blobRef = new BlobRef(ANY_NODE, blobStore.getBlobStoreConfiguration().getName(), blobId.asUniqueString());
        Throwable throwable = null;
        Object var6_7 = null;
        try (ODatabaseDocumentTx tx = this.txSupplier.get();){
            tx.begin();
            List results = (List)tx.command(this.assetBlobRefQuery).execute(new Object[]{blobName, blobRef.toString()});
            boolean bl = !results.isEmpty();
            return bl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

