/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.validation.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.inject.BeanLocator;
import org.sonatype.goodies.common.ComponentSupport;

@Singleton
public final class GuiceConstraintValidatorFactory
extends ComponentSupport
implements ConstraintValidatorFactory {
    private final BeanLocator beanLocator;

    @Inject
    public GuiceConstraintValidatorFactory(BeanLocator beanLocator) {
        this.beanLocator = (BeanLocator)Preconditions.checkNotNull((Object)beanLocator);
    }

    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
        this.log.trace("Resolving validator instance for type: {}", key);
        return (T)((ConstraintValidator)((BeanEntry)this.beanLocator.locate(Key.get(key)).iterator().next()).getValue());
    }

    public void releaseInstance(ConstraintValidator<?, ?> instance) {
    }
}

