/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.validation;

import com.google.common.base.Preconditions;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintViolations {
    private static final Logger log = LoggerFactory.getLogger(ConstraintViolations.class);

    private ConstraintViolations() {
    }

    public static void maybePropagate(Set<? extends ConstraintViolation<?>> violations, Logger log) {
        Preconditions.checkNotNull(violations);
        Preconditions.checkNotNull((Object)log);
        if (!violations.isEmpty()) {
            String message = String.format("Validation failed; %d constraints violated", violations.size());
            if (log.isWarnEnabled()) {
                StringBuilder buff = new StringBuilder();
                int c = 0;
                for (ConstraintViolation<?> violation : violations) {
                    buff.append("  ").append(++c).append(") ").append(violation.getMessage()).append(", type: ").append(violation.getRootBeanClass()).append(", property: ").append(violation.getPropertyPath()).append(", value: ").append(violation.getInvalidValue()).append(System.lineSeparator());
                }
                log.warn("{}:{}{}", new Object[]{message, System.lineSeparator(), buff});
            }
            throw new ConstraintViolationException(message, violations);
        }
    }

    public static void maybeAdd(Set<ConstraintViolation<?>> violations, ConstraintViolation<?> ... toAdd) {
        ConstraintViolation<?>[] constraintViolationArray = toAdd;
        int n = toAdd.length;
        int n2 = 0;
        while (n2 < n) {
            ConstraintViolation<?> violation = constraintViolationArray[n2];
            if (violation != null) {
                violations.add(violation);
            }
            ++n2;
        }
    }

    public static void maybePropagate(Set<? extends ConstraintViolation<?>> violations) {
        ConstraintViolations.maybePropagate(violations, log);
    }
}

