/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.jpa;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.core4j.Enumerable;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OProperty;
import org.odata4j.expression.BoolCommonExpression;
import org.odata4j.expression.CommonExpression;
import org.odata4j.expression.EntitySimpleProperty;
import org.odata4j.expression.EqExpression;
import org.odata4j.expression.Expression;
import org.odata4j.expression.LiteralExpression;
import org.odata4j.expression.OrderByExpression;

public class JPASkipToken {
    public static String create(List<OrderByExpression> orderByList, OEntity lastEntity) {
        LinkedList<String> values = new LinkedList<String>();
        if (orderByList != null) {
            for (OrderByExpression orderBy : orderByList) {
                String orderByPropName = ((EntitySimpleProperty)orderBy.getExpression()).getPropertyName();
                Object orderByPropValue = lastEntity.getProperty(orderByPropName).getValue();
                String valueFilterString = Expression.asFilterString(Expression.literal(orderByPropValue));
                values.add(valueFilterString);
            }
        }
        values.add(lastEntity.getEntityKey().toKeyStringWithoutParentheses());
        return Enumerable.create(values).join(",");
    }

    public static BoolCommonExpression parse(String primaryKeyName, List<OrderByExpression> orderByList, String skipToken, String ... names) {
        BoolCommonExpression keyPredicate;
        OEntityKey entityKey;
        if (skipToken == null) {
            return null;
        }
        ArrayList<BoolCommonExpression> predicates = new ArrayList<BoolCommonExpression>();
        ArrayList<LiteralExpression> orderByValues = new ArrayList<LiteralExpression>();
        int start = 0;
        int end = 0;
        if (orderByList != null) {
            for (int i = 0; i < orderByList.size(); ++i) {
                OrderByExpression orderBy = orderByList.get(i);
                end = skipToken.indexOf(44, start);
                String orderByValueString = skipToken.substring(start, end);
                LiteralExpression orderByValue = (LiteralExpression)Expression.parse(orderByValueString);
                orderByValues.add(orderByValue);
                BoolCommonExpression ordExp = orderBy.getDirection() == OrderByExpression.Direction.ASCENDING ? Expression.gt(orderBy.getExpression(), orderByValue) : Expression.lt(orderBy.getExpression(), orderByValue);
                predicates.add(ordExp);
                start = end + 1;
            }
        }
        if ((entityKey = OEntityKey.parse(skipToken.substring(start), names)).getKeyType() == OEntityKey.KeyType.SINGLE) {
            LiteralExpression entityKeyValue = Expression.literal(entityKey.asSingleValue());
            keyPredicate = Expression.gt(Expression.simpleProperty(primaryKeyName), entityKeyValue);
            predicates.add(keyPredicate);
        } else {
            ArrayList keyProperties = new ArrayList(entityKey.asComplexProperties());
            keyPredicate = null;
            String prefix = primaryKeyName != null ? primaryKeyName + "." : "";
            for (int i = 0; i < keyProperties.size(); ++i) {
                OProperty keyProperty = (OProperty)keyProperties.get(i);
                BoolCommonExpression subPredicate = Expression.gt(Expression.simpleProperty(prefix + keyProperty.getName()), Expression.literal(keyProperty.getValue()));
                for (int j = i - 1; j >= 0; --j) {
                    OProperty earlierKeyProperty = (OProperty)keyProperties.get(j);
                    EqExpression eq = Expression.eq(Expression.simpleProperty(prefix + earlierKeyProperty.getName()), Expression.literal(earlierKeyProperty.getValue()));
                    subPredicate = Expression.and(eq, subPredicate);
                }
                keyPredicate = keyPredicate == null ? subPredicate : Expression.boolParen(Expression.or(keyPredicate, subPredicate));
            }
            predicates.add(keyPredicate);
        }
        for (int i = 1; i < predicates.size(); ++i) {
            BoolCommonExpression predicate = (BoolCommonExpression)predicates.get(i);
            for (int j = i - 1; j >= 0; --j) {
                OrderByExpression orderBy = orderByList.get(j);
                EqExpression eq = Expression.eq(orderBy.getExpression(), (CommonExpression)orderByValues.get(j));
                predicate = Expression.and(eq, predicate);
            }
            predicates.set(i, Expression.boolParen(predicate));
        }
        BoolCommonExpression rt = (BoolCommonExpression)predicates.get(0);
        for (int i = 1; i < predicates.size(); ++i) {
            rt = Expression.or(rt, (BoolCommonExpression)predicates.get(i));
        }
        return rt;
    }
}

