/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.persist.internal.orient;

import com.sonatype.nexus.saml.persist.entity.SamlUser;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonatype.nexus.common.entity.AbstractEntity;
import org.sonatype.nexus.security.user.UserStatus;

public class OrientSamlUser
extends AbstractEntity
implements SamlUser {
    private String firstName;
    private String id;
    private String lastName;
    private String status;
    private String email;
    private Set<String> roles = new HashSet<String>();

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public boolean isActive() {
        return UserStatus.active.toString().equals(this.status);
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    @Override
    public Set<String> getRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "id='" + this.id + '\'' + ", firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", status='" + this.status + '\'' + ", roles=['" + this.roles.stream().collect(Collectors.joining(", '")) + '\'' + '}';
    }
}

