/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.persist.internal.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.sonatype.nexus.saml.persist.entity.Mapping;
import com.sonatype.nexus.saml.persist.internal.SamlSecurityHelper;
import com.sonatype.nexus.saml.persist.internal.orient.OrientSamlConfiguration;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.security.PasswordHelper;

@Named
@Singleton
public class OrientSamlConfigurationEntityAdapter
extends IterableEntityAdapter<OrientSamlConfiguration> {
    private static final String P_ID = "id";
    private static final String P_ENTITY_ID = "entityId";
    private static final String P_IDP_METADATA = "idpMetadata";
    private static final String P_MAPPING = "mapping";
    private static final String P_VALIDATE_RESPONSE_SIGNATURE = "validateResponseSignature";
    private static final String P_VALIDATE_ASSERTION_SIGNATURE = "validateAssertionSignature";
    private static final String P_KEY_STORE_PASSWORD = "keyStorePassword";
    private static final String P_KEY_STORE_BYTES = "keyStoreBytes";
    private static final String USERNAME_ATTRIBUTE_NAME = "usernameAttributeName";
    private static final String FIRST_NAME_ATTRIBUTE_NAME = "firstNameAttributeName";
    private static final String LAST_NAME_ATTRIBUTE_NAME = "lastNameAttributeName";
    private static final String EMAIL_ATTRIBUTE_NAME = "emailAttributeName";
    private static final String GROUPS_ATTRIBUTE_NAME = "groupsAttributeName";
    private static final String DB_CLASS = new OClassNameBuilder().type("saml").build();
    private static final String DB_MAPPING_CLASS = new OClassNameBuilder().prefix("saml").type("mapping").build();
    private static final String I_ID = new OIndexNameBuilder().type(DB_CLASS).property("id").build();
    private final PasswordHelper passwordHelper;
    private final SamlSecurityHelper samlSecurityHelper;

    @Inject
    public OrientSamlConfigurationEntityAdapter(PasswordHelper passwordHelper, SamlSecurityHelper samlSecurityHelper) {
        super(DB_CLASS);
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
        this.samlSecurityHelper = (SamlSecurityHelper)((Object)Preconditions.checkNotNull((Object)((Object)samlSecurityHelper)));
    }

    public ODocument selectById(ODatabaseDocumentTx db, String id) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)id);
        List results = (List)db.command(this.selectAllById()).execute(new Object[]{id});
        return results.stream().findFirst().orElse(null);
    }

    protected void defineType(ODatabaseDocumentTx db, OClass type) {
        OSchemaProxy schema = db.getMetadata().getSchema();
        OClass mappingType = schema.createClass(DB_MAPPING_CLASS);
        mappingType.createProperty(USERNAME_ATTRIBUTE_NAME, OType.STRING).setNotNull(true);
        mappingType.createProperty(FIRST_NAME_ATTRIBUTE_NAME, OType.STRING);
        mappingType.createProperty(LAST_NAME_ATTRIBUTE_NAME, OType.STRING);
        mappingType.createProperty(EMAIL_ATTRIBUTE_NAME, OType.STRING);
        mappingType.createProperty(GROUPS_ATTRIBUTE_NAME, OType.STRING);
        type.createProperty(P_ID, OType.STRING).setNotNull(true);
        type.createProperty(P_ENTITY_ID, OType.STRING).setNotNull(true);
        type.createProperty(P_IDP_METADATA, OType.STRING).setNotNull(true);
        type.createProperty(P_MAPPING, OType.EMBEDDED, mappingType).setNotNull(true);
        type.createProperty(P_VALIDATE_RESPONSE_SIGNATURE, OType.BOOLEAN);
        type.createProperty(P_VALIDATE_ASSERTION_SIGNATURE, OType.BOOLEAN);
        type.createProperty(P_KEY_STORE_PASSWORD, OType.STRING).setNotNull(true);
        type.createProperty(P_KEY_STORE_BYTES, OType.BINARY).setNotNull(true);
        type.createIndex(I_ID, OClass.INDEX_TYPE.UNIQUE, new String[]{P_ID});
    }

    protected void defineType(OClass type) {
        throw new UnsupportedOperationException();
    }

    protected OrientSamlConfiguration newEntity() {
        return new OrientSamlConfiguration();
    }

    protected void readFields(ODocument document, OrientSamlConfiguration entity) {
        entity.setId((String)document.field(P_ID, OType.STRING));
        entity.setEntityId((String)document.field(P_ENTITY_ID, OType.STRING));
        entity.setIdpMetadata((String)document.field(P_IDP_METADATA, OType.STRING));
        entity.setMapping(this.toMapping((ODocument)document.field(P_MAPPING, OType.EMBEDDED)));
        entity.setValidateResponseSignature((Boolean)document.field(P_VALIDATE_RESPONSE_SIGNATURE, OType.BOOLEAN));
        entity.setValidateAssertionSignature((Boolean)document.field(P_VALIDATE_ASSERTION_SIGNATURE, OType.BOOLEAN));
        String keyStorePassword = this.passwordHelper.tryDecrypt((String)document.field(P_KEY_STORE_PASSWORD, OType.STRING));
        byte[] keyStoreBytes = (byte[])document.field(P_KEY_STORE_BYTES, OType.BINARY);
        this.samlSecurityHelper.setKeyStore(entity, keyStorePassword, keyStoreBytes);
    }

    protected void writeFields(ODocument document, OrientSamlConfiguration entity) {
        if (entity.getKeyStorePassword() == null && entity.getKeyStoreBytes() == null) {
            this.samlSecurityHelper.newKeyStore(entity);
        }
        document.field(P_ID, (Object)entity.getId());
        document.field(P_ENTITY_ID, (Object)entity.getEntityId());
        document.field(P_IDP_METADATA, (Object)entity.getIdpMetadata());
        document.field(P_MAPPING, (Object)this.fromMapping(entity.getMapping()));
        document.field(P_VALIDATE_RESPONSE_SIGNATURE, (Object)entity.getValidateResponseSignature());
        document.field(P_VALIDATE_ASSERTION_SIGNATURE, (Object)entity.getValidateAssertionSignature());
        document.field(P_KEY_STORE_PASSWORD, (Object)this.passwordHelper.encrypt(entity.getKeyStorePassword()));
        document.field(P_KEY_STORE_BYTES, (Object)entity.getKeyStoreBytes());
    }

    private OSQLSynchQuery<ODocument> selectAllById() {
        return new OSQLSynchQuery(String.format("SELECT FROM %s WHERE %s = ?", DB_CLASS, P_ID));
    }

    private Mapping toMapping(ODocument document) {
        Mapping mapping = new Mapping();
        mapping.setUsernameAttributeName((String)document.field(USERNAME_ATTRIBUTE_NAME, OType.STRING));
        mapping.setFirstNameAttributeName((String)document.field(FIRST_NAME_ATTRIBUTE_NAME, OType.STRING));
        mapping.setLastNameAttributeName((String)document.field(LAST_NAME_ATTRIBUTE_NAME, OType.STRING));
        mapping.setEmailAttributeName((String)document.field(EMAIL_ATTRIBUTE_NAME, OType.STRING));
        mapping.setGroupsAttributeName((String)document.field(GROUPS_ATTRIBUTE_NAME, OType.STRING));
        return mapping;
    }

    private ODocument fromMapping(Mapping mapping) {
        ODocument document = new ODocument(DB_MAPPING_CLASS);
        document.field(USERNAME_ATTRIBUTE_NAME, (Object)mapping.getUsernameAttributeName());
        document.field(FIRST_NAME_ATTRIBUTE_NAME, (Object)mapping.getFirstNameAttributeName());
        document.field(LAST_NAME_ATTRIBUTE_NAME, (Object)mapping.getLastNameAttributeName());
        document.field(EMAIL_ATTRIBUTE_NAME, (Object)mapping.getEmailAttributeName());
        document.field(GROUPS_ATTRIBUTE_NAME, (Object)mapping.getGroupsAttributeName());
        return document;
    }
}

