/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.persist.internal;

import com.sonatype.nexus.saml.persist.entity.SamlUser;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.security.role.RoleIdentifier;
import org.sonatype.nexus.security.user.User;
import org.sonatype.nexus.security.user.UserSearchCriteria;

public class SamlUserUtil {
    private SamlUserUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static SamlUser userToSamlUser(User user, SamlUser samlUser) {
        samlUser.setId(user.getUserId());
        samlUser.setStatus(user.getStatus().toString());
        samlUser.setEmail(user.getEmailAddress());
        samlUser.setFirstName(user.getFirstName());
        samlUser.setLastName(user.getLastName());
        samlUser.setRoles(user.getRoles().stream().map(RoleIdentifier::getRoleId).collect(Collectors.toSet()));
        return samlUser;
    }

    public static Set<User> filterUsers(UserSearchCriteria criteria, List<SamlUser> samlUsers) {
        HashSet<User> filteredUsers = new HashSet<User>();
        if (Strings2.isBlank((String)criteria.getUserId())) {
            filteredUsers.addAll(samlUsers.stream().map(SamlUser::toUser).collect(Collectors.toList()));
        } else {
            filteredUsers.addAll(samlUsers.stream().filter(samlUser -> samlUser.getId().toLowerCase().startsWith(criteria.getUserId().toLowerCase())).map(SamlUser::toUser).collect(Collectors.toList()));
        }
        return filteredUsers;
    }
}

