/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.persist.internal;

import com.sonatype.nexus.saml.persist.entity.SamlConfiguration;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Date;
import java.util.UUID;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.sonatype.goodies.common.ComponentSupport;

@Named
@Singleton
public class SamlSecurityHelper
extends ComponentSupport {
    private static final String KEYSTORE_ALIAS = "SAML";
    private static final long TEN_YEARS_IN_SECONDS = Duration.ofDays(3650L).getSeconds();

    public void newKeyStore(SamlConfiguration config) {
        try {
            KeyStore keyStore = KeyStore.getInstance("pkcs12");
            String keyStorePassword = this.generatePassword();
            keyStore.load(null, keyStorePassword.toCharArray());
            Provider provider = Security.getProvider("BC");
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", provider);
            keyPairGenerator.initialize(2048, new SecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            Certificate[] certificateChain = new X509Certificate[]{this.createSamlCertificate(provider, keyPair)};
            keyStore.setKeyEntry(KEYSTORE_ALIAS, keyPair.getPrivate(), keyStorePassword.toCharArray(), certificateChain);
            Throwable throwable = null;
            Object var9_11 = null;
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                keyStore.store(byteArrayOutputStream, keyStorePassword.toCharArray());
                this.setKeyStore(config, keyStorePassword, byteArrayOutputStream.toByteArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log.error("Could not generate SAML keystore.", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public void setKeyStore(SamlConfiguration config, String keyStorePassword, byte[] keyStoreBytes) {
        config.setKeyStorePassword(keyStorePassword);
        config.setKeyStoreBytes(keyStoreBytes);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ByteArrayInputStream keystoreInputStream = new ByteArrayInputStream(keyStoreBytes);){
                KeyStore keyStore = KeyStore.getInstance("pkcs12");
                keyStore.load(keystoreInputStream, keyStorePassword.toCharArray());
                Certificate certificate = keyStore.getCertificate(KEYSTORE_ALIAS);
                config.setCertificate(certificate);
                PrivateKey privateKey = (PrivateKey)keyStore.getKey(KEYSTORE_ALIAS, keyStorePassword.toCharArray());
                config.setDecryptionKey(privateKey);
                config.setSigningKeyPair(new KeyPair(certificate.getPublicKey(), privateKey));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private String generatePassword() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private X509Certificate createSamlCertificate(Provider provider, KeyPair keyPair) throws OperatorCreationException, CertificateException {
        long now = System.currentTimeMillis();
        Date startDate = new Date(now);
        Date endDate = new Date(now + 1000L * TEN_YEARS_IN_SECONDS);
        X500Name dnName = new X500Name("CN=SAML KeyStore");
        BigInteger certSerialNumber = new BigInteger(Long.toString(now));
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(dnName, certSerialNumber, startDate, endDate, dnName, keyPair.getPublic());
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSA").build(keyPair.getPrivate());
        JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
        return jcaX509CertificateConverter.setProvider(provider).getCertificate(certBuilder.build(contentSigner));
    }
}

