/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.persist.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.saml.internal.SamlDeploymentManager;
import com.sonatype.nexus.saml.persist.SamlConfigurationException;
import com.sonatype.nexus.saml.persist.SamlConfigurationManager;
import com.sonatype.nexus.saml.persist.SamlConfigurationValidator;
import com.sonatype.nexus.saml.persist.entity.Mapping;
import com.sonatype.nexus.saml.persist.entity.SamlConfiguration;
import com.sonatype.nexus.saml.persist.internal.SamlConfigurationStore;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.BaseUrlHolder;

@Named
@Singleton
public class DefaultSamlConfigurationManager
implements SamlConfigurationManager {
    private final SamlConfigurationStore configurationStore;
    private final SamlConfigurationValidator configurationValidator;
    private final Object monitor = new Object[0];
    private final SamlDeploymentManager samlDeploymentManager;

    @Inject
    public DefaultSamlConfigurationManager(SamlConfigurationStore configurationStore, SamlConfigurationValidator configurationValidator, SamlDeploymentManager samlDeploymentManager) {
        this.configurationStore = configurationStore;
        this.configurationValidator = configurationValidator;
        this.samlDeploymentManager = (SamlDeploymentManager)((Object)Preconditions.checkNotNull((Object)((Object)samlDeploymentManager)));
    }

    @Override
    public SamlConfiguration newConfiguration() {
        SamlConfiguration configuration = this.configurationStore.newEntity();
        this.setDefaults(configuration);
        return configuration;
    }

    @Override
    public SamlConfiguration loadConfiguration() {
        return this.configurationStore.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SamlConfiguration create(SamlConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        this.configurationValidator.validate(configuration);
        Object object = this.monitor;
        synchronized (object) {
            this.checkNoMultipleConfigurations();
            this.configurationStore.create(configuration);
        }
        SamlConfiguration samlConfiguration = this.loadConfiguration();
        this.samlDeploymentManager.updateFromConfiguration(samlConfiguration);
        return samlConfiguration;
    }

    @Override
    public SamlConfiguration update(SamlConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        this.configurationValidator.validate(configuration);
        this.checkExistenceForUpdate(configuration);
        this.configurationStore.update(configuration);
        SamlConfiguration samlConfiguration = this.loadConfiguration();
        this.samlDeploymentManager.updateFromConfiguration(samlConfiguration);
        return samlConfiguration;
    }

    @Override
    public void delete() {
        SamlConfiguration configuration = this.loadConfiguration();
        if (configuration != null) {
            this.configurationStore.delete(configuration.getId());
            this.samlDeploymentManager.clearSamlDeployment();
        }
    }

    private void checkNoMultipleConfigurations() {
        if (Objects.nonNull(this.loadConfiguration())) {
            throw new SamlConfigurationException("Can only have one SAML configuration.");
        }
    }

    private void checkExistenceForUpdate(SamlConfiguration configuration) {
        SamlConfiguration existingConfiguration = this.loadConfiguration();
        if (Objects.isNull(existingConfiguration)) {
            throw new SamlConfigurationException("No SAML configuration existed to update.");
        }
        if (!Objects.equals(existingConfiguration.getId(), configuration.getId())) {
            throw new SamlConfigurationException("The SAML configuration to update does not match the existing SAML configuration");
        }
    }

    private void setDefaults(SamlConfiguration configuration) {
        configuration.setEntityId(String.valueOf(BaseUrlHolder.get()) + "/service/rest" + "/v1/security/saml" + "/metadata");
        configuration.setMapping(new Mapping());
    }
}

