/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.internal.rest;

import com.sonatype.nexus.saml.persist.entity.Mapping;
import com.sonatype.nexus.saml.persist.entity.SamlConfiguration;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.validation.constraint.UriString;

public class SamlConfigurationXO {
    private String idpMetadata = "";
    @UriString
    private String entityIdUri = "";
    @NotBlank
    private String usernameAttr = "username";
    private String firstNameAttr = "";
    private String lastNameAttr = "";
    private String emailAttr = "";
    private String roleAttr = "";
    private Boolean validateResponseSignature;
    private Boolean validateAssertionSignature;

    public static SamlConfigurationXO fromSamlConfiguration(SamlConfiguration configuration) {
        SamlConfigurationXO xo = new SamlConfigurationXO();
        if (configuration != null) {
            xo.setIdpMetadata(StringUtils.defaultString((String)configuration.getIdpMetadata()));
            xo.setEntityIdUri(StringUtils.defaultString((String)configuration.getEntityId()));
            xo.setUsernameAttr(StringUtils.defaultString((String)configuration.getMapping().getUsernameAttributeName()));
            xo.setFirstNameAttr(StringUtils.defaultString((String)configuration.getMapping().getFirstNameAttributeName()));
            xo.setLastNameAttr(StringUtils.defaultString((String)configuration.getMapping().getLastNameAttributeName()));
            xo.setEmailAttr(StringUtils.defaultString((String)configuration.getMapping().getEmailAttributeName()));
            xo.setRoleAttr(StringUtils.defaultString((String)configuration.getMapping().getGroupsAttributeName()));
            xo.setValidateAssertionSignature(configuration.getValidateAssertionSignature());
            xo.setValidateResponseSignature(configuration.getValidateResponseSignature());
        }
        return xo;
    }

    public static SamlConfiguration toSamlConfiguration(SamlConfigurationXO xo, SamlConfiguration configuration) {
        configuration.setIdpMetadata(xo.getIdpMetadata());
        configuration.setEntityId(xo.getEntityIdUri());
        configuration.setValidateAssertionSignature(xo.getValidateAssertionSignature());
        configuration.setValidateResponseSignature(xo.getValidateResponseSignature());
        Mapping mapping = new Mapping();
        mapping.setUsernameAttributeName(xo.getUsernameAttr());
        mapping.setFirstNameAttributeName(xo.getFirstNameAttr());
        mapping.setLastNameAttributeName(xo.getLastNameAttr());
        mapping.setEmailAttributeName(xo.getEmailAttr());
        mapping.setGroupsAttributeName(xo.getRoleAttr());
        configuration.setMapping(mapping);
        return configuration;
    }

    public String getIdpMetadata() {
        return this.idpMetadata;
    }

    public void setIdpMetadata(String idpMetadata) {
        this.idpMetadata = idpMetadata;
    }

    public String getEntityIdUri() {
        return this.entityIdUri;
    }

    public void setEntityIdUri(String entityIdUri) {
        this.entityIdUri = entityIdUri;
    }

    public String getUsernameAttr() {
        return this.usernameAttr;
    }

    public void setUsernameAttr(String usernameAttr) {
        this.usernameAttr = usernameAttr;
    }

    public String getFirstNameAttr() {
        return this.firstNameAttr;
    }

    public void setFirstNameAttr(String firstNameAttr) {
        this.firstNameAttr = firstNameAttr;
    }

    public String getLastNameAttr() {
        return this.lastNameAttr;
    }

    public void setLastNameAttr(String lastNameAttr) {
        this.lastNameAttr = lastNameAttr;
    }

    public String getEmailAttr() {
        return this.emailAttr;
    }

    public void setEmailAttr(String emailAttr) {
        this.emailAttr = emailAttr;
    }

    public String getRoleAttr() {
        return this.roleAttr;
    }

    public void setRoleAttr(String roleAttr) {
        this.roleAttr = roleAttr;
    }

    public Boolean getValidateResponseSignature() {
        return this.validateResponseSignature;
    }

    public void setValidateResponseSignature(Boolean validateResponseSignature) {
        this.validateResponseSignature = validateResponseSignature;
    }

    public Boolean getValidateAssertionSignature() {
        return this.validateAssertionSignature;
    }

    public void setValidateAssertionSignature(Boolean validateAssertionSignature) {
        this.validateAssertionSignature = validateAssertionSignature;
    }
}

