/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.internal;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class SamlUserPrincipal {
    private final String username;
    private final String displayName;
    private final Set<String> membership = new LinkedHashSet<String>();

    public SamlUserPrincipal(String username, String displayName) {
        this.username = username;
        this.displayName = displayName;
    }

    public SamlUserPrincipal(String username, String displayName, Set<String> membership) {
        this(username, displayName);
        if (membership != null) {
            this.membership.addAll(membership);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Set<String> getMembership() {
        return this.membership;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamlUserPrincipal that = (SamlUserPrincipal)o;
        return Objects.equals(this.username, that.username) && Objects.equals(this.displayName, that.displayName);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.displayName);
    }

    public String toString() {
        return this.getUsername();
    }
}

