/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.saml.internal.SamlPrincipalUtil;
import com.sonatype.nexus.saml.persist.SamlConfigurationManager;
import com.sonatype.nexus.saml.persist.entity.SamlConfiguration;
import com.sonatype.nexus.saml.persist.entity.SamlUser;
import com.sonatype.nexus.saml.persist.internal.SamlUserStore;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.keycloak.adapters.saml.SamlPrincipal;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.security.config.SecurityConfigurationSource;
import org.sonatype.nexus.security.user.User;
import org.sonatype.nexus.security.user.UserManager;
import org.sonatype.nexus.security.user.UserNotFoundException;
import org.sonatype.nexus.security.user.UserSearchCriteria;
import org.sonatype.nexus.security.user.UserStatus;

@Singleton
@Named(value="SAML")
public class SamlUserManager
extends ComponentSupport
implements UserManager {
    SecurityConfigurationSource securityConfigurationSource;
    private final SamlConfigurationManager configurationManager;
    private final SamlUserStore samlUserStore;
    private final SecuritySystem securitySystem;

    @Inject
    public SamlUserManager(SamlConfigurationManager configurationManager, SamlUserStore samlUserStore, SecuritySystem securitySystem, SecurityConfigurationSource securityConfigurationSource) {
        this.configurationManager = (SamlConfigurationManager)Preconditions.checkNotNull((Object)configurationManager);
        this.samlUserStore = (SamlUserStore)Preconditions.checkNotNull((Object)samlUserStore);
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull((Object)securitySystem);
        this.securityConfigurationSource = (SecurityConfigurationSource)Preconditions.checkNotNull((Object)securityConfigurationSource);
    }

    public String getSource() {
        return "SAML";
    }

    public String getAuthenticationRealmName() {
        return "SamlRealm";
    }

    public boolean supportsWrite() {
        return false;
    }

    public Set<User> listUsers() {
        return this.samlUserStore.list().stream().map(SamlUser::toUser).collect(Collectors.toSet());
    }

    public Set<String> listUserIds() {
        return this.samlUserStore.listUserIds();
    }

    public User addUser(User user, String password) {
        throw new UnsupportedOperationException("SAML users can't have passwords");
    }

    public User updateUser(User user) throws UserNotFoundException {
        this.samlUserStore.update(user);
        return user;
    }

    public void deleteUser(String userId) throws UserNotFoundException {
        this.securityConfigurationSource.getConfiguration().removeUserRoleMapping(userId, "SAML");
        this.samlUserStore.deleteUser(userId);
    }

    public Set<User> searchUsers(UserSearchCriteria criteria) {
        return this.samlUserStore.searchUsers(criteria);
    }

    public User getUser(String userId) throws UserNotFoundException {
        SamlUser samlUser = this.samlUserStore.getUser(userId);
        if (samlUser == null) {
            throw new UserNotFoundException(userId);
        }
        return samlUser.toUser();
    }

    public void changePassword(String userId, String newPassword) {
        throw new UnsupportedOperationException("SAML users can't change passwords");
    }

    public User addUser(SamlPrincipal samlPrincipal) {
        SamlConfiguration configuration = this.configurationManager.loadConfiguration();
        SamlUser samlUser = this.samlUserStore.newEntity();
        samlUser = SamlPrincipalUtil.toNewSamlUser(samlPrincipal, configuration.getMapping(), samlUser);
        samlUser.setStatus(UserStatus.active.name());
        samlUser.setRoles(SamlPrincipalUtil.extractGroups(samlPrincipal, configuration.getMapping()));
        this.samlUserStore.create(samlUser);
        return samlUser.toUser();
    }
}

