/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.internal;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import com.sonatype.nexus.saml.internal.SamlFilter;
import com.sonatype.nexus.saml.internal.SamlLogoutFilter;
import javax.inject.Named;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.security.FilterChainModule;
import org.sonatype.nexus.security.FilterProviderSupport;
import org.sonatype.nexus.security.SecurityFilter;

@Named
@FeatureFlag(name="nexus.session.enabled")
public class SamlModule
extends AbstractModule {
    protected static final String MOUNT_POINT = "/saml";

    protected void configure() {
        this.bindSamlFilter();
        this.install((Module)this.configureServletModule());
        this.install(this.configureFilterChainModule());
    }

    protected void bindSamlFilter() {
        this.bind(FilterProviderSupport.filterKey((String)"nx-saml-auth")).to(SamlFilter.class);
    }

    protected ServletModule configureServletModule() {
        return new ServletModule(){

            protected void configureServlets() {
                this.filter(SamlModule.MOUNT_POINT, new String[0]).through(SecurityFilter.class);
                this.filter(SamlModule.MOUNT_POINT, new String[0]).through(SamlFilter.class);
                this.filter("/service/rapture/session", new String[0]).through(SamlLogoutFilter.class);
            }
        };
    }

    protected Module configureFilterChainModule() {
        return new FilterChainModule(){

            protected void configure() {
                this.addFilterChain(SamlModule.MOUNT_POINT, "nx-saml-auth");
            }
        };
    }
}

