/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.internal;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.EntitiesDescriptorType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.IDPSSODescriptorType;
import org.keycloak.saml.processing.core.parsers.saml.SAMLParser;
import org.keycloak.saml.processing.core.util.JAXPValidationUtil;
import org.sonatype.nexus.common.io.SafeXml;
import org.xml.sax.SAXException;

@Named
@Singleton
public class SamlMetadataTool {
    public static final URI POST_BINDING = URI.create("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
    public static final URI REDIRECT_BINDING = URI.create("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");

    public SamlMetadataTool() throws IOException, SAXException {
        SafeXml.configureValidator((Validator)JAXPValidationUtil.validator());
    }

    public EntityDescriptorType parseEntityDescriptor(String xmlMetadata) {
        EntityDescriptorType entityDescriptor = this.getEntityDescriptorType(this.getMetaData(xmlMetadata));
        List idpDescriptors = entityDescriptor.getChoiceType().stream().flatMap(choiceType -> choiceType.getDescriptors().stream()).map(EntityDescriptorType.EDTDescriptorChoiceType::getIdpDescriptor).filter(Objects::nonNull).collect(Collectors.toList());
        if (idpDescriptors.size() != 1) {
            throw new IllegalArgumentException("Invalid SAML identity provider count: " + idpDescriptors.size());
        }
        if (((IDPSSODescriptorType)idpDescriptors.get(0)).getSingleSignOnService().stream().map(EndpointType::getBinding).noneMatch(binding -> POST_BINDING.equals(binding) || REDIRECT_BINDING.equals(binding))) {
            throw new IllegalArgumentException("SAML identity provider supports neither POST nor Redirect binding for SSO");
        }
        return entityDescriptor;
    }

    private EntityDescriptorType getEntityDescriptorType(Object metadata) {
        EntityDescriptorType entityDescriptor;
        if (metadata instanceof EntityDescriptorType) {
            entityDescriptor = (EntityDescriptorType)metadata;
        } else if (metadata instanceof EntitiesDescriptorType) {
            EntitiesDescriptorType entities = (EntitiesDescriptorType)metadata;
            if (entities.getEntityDescriptor().size() != 1) {
                throw new IllegalArgumentException("Invalid SAML entity descriptor count: " + entities.getEntityDescriptor().size());
            }
            entityDescriptor = (EntityDescriptorType)entities.getEntityDescriptor().get(0);
        } else {
            throw new IllegalArgumentException("Invalid SAML metadata type: " + metadata.getClass());
        }
        return entityDescriptor;
    }

    private Object getMetaData(String xmlMetadata) {
        Object metadata;
        try {
            JAXPValidationUtil.validator().validate(new StreamSource(new StringReader(xmlMetadata)));
            metadata = SAMLParser.getInstance().parse((Source)new StreamSource(new StringReader(xmlMetadata)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid SAML metadata: " + e.getMessage(), e);
        }
        return metadata;
    }
}

