/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.saml.internal.SamlSessionManager;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

@Named
@Singleton
public class SamlLogoutFilter
implements Filter {
    private final SamlSessionManager samlSessionManager;

    @Inject
    public SamlLogoutFilter(SamlSessionManager samlSessionManager) {
        this.samlSessionManager = (SamlSessionManager)Preconditions.checkNotNull((Object)samlSessionManager);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpSession session;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        if ("DELETE".equals(httpServletRequest.getMethod()) && (session = httpServletRequest.getSession(false)) != null) {
            this.samlSessionManager.getIdMapper().removeSession(session.getId());
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

