/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.saml.internal.SamlAuthenticatorForSamlEndpoint;
import com.sonatype.nexus.saml.internal.SamlDeploymentManager;
import com.sonatype.nexus.saml.internal.SamlSessionManager;
import com.sonatype.nexus.saml.internal.SamlSessionStoreForRedirect;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.apache.shiro.web.filter.authc.AuthenticationFilter;
import org.keycloak.adapters.saml.SamlAuthenticator;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.servlet.ServletHttpFacade;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.app.BaseUrlHolder;

@Named
@Singleton
public class SamlFilter
extends AuthenticationFilter {
    public static final String NAME = "nx-saml-auth";
    private static final Logger log = LoggerFactory.getLogger(SamlFilter.class);
    static final String MSG_SAML_FAILURE = "Authentication failed due to SAML error. Please contact your IT administrator.";
    static final String MSG_SAML_DISABLED = "The SAML security realm must be enabled to log in via SAML.";
    public static final String TEXT_PLAIN_CHARSET_UTF_8 = "text/plain;charset=UTF-8";
    private final SamlDeploymentManager samlDeploymentManager;
    private final SamlSessionManager samlSessionManager;

    @Inject
    public SamlFilter(SamlDeploymentManager samlDeploymentManager, SamlSessionManager samlSessionManager) {
        this.samlDeploymentManager = (SamlDeploymentManager)((Object)Preconditions.checkNotNull((Object)((Object)samlDeploymentManager)));
        this.samlSessionManager = (SamlSessionManager)Preconditions.checkNotNull((Object)samlSessionManager);
    }

    public boolean onPreHandle(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        AuthOutcome outcome;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        RealmSecurityManager realmSecurityManager = (RealmSecurityManager)SecurityUtils.getSecurityManager();
        List activeSecurityRealms = realmSecurityManager.getRealms().stream().map(Realm::getName).collect(Collectors.toList());
        if (!activeSecurityRealms.contains("SamlRealm")) {
            log.debug("SAML Realm is disabled, do not redirect to the configured saml system");
            this.handleDisabled(httpResponse);
            return false;
        }
        SamlDeployment samlDeployment = this.samlDeploymentManager.getSamlDeployment();
        if (samlDeployment == null) {
            return true;
        }
        ServletHttpFacade httpFacade = new ServletHttpFacade(httpRequest, httpResponse);
        SamlSessionStore samlSessionStore = this.newSamlSessionStore(httpRequest, (HttpFacade)httpFacade, samlDeployment);
        SamlAuthenticator samlAuthenticator = this.newSamlAuthenticator(httpFacade, samlDeployment, samlSessionStore);
        try {
            outcome = samlAuthenticator.authenticate();
        }
        catch (Exception e) {
            log.error("SAML authentication failed: {}", (Object)e.getMessage(), (Object)e);
            outcome = AuthOutcome.FAILED;
        }
        if (outcome == AuthOutcome.AUTHENTICATED) {
            httpResponse.sendRedirect(BaseUrlHolder.get());
            return false;
        }
        if (outcome == AuthOutcome.NOT_ATTEMPTED && this.isAccessAllowed(request, response, mappedValue)) {
            return true;
        }
        if (outcome == AuthOutcome.LOGGED_OUT) {
            this.handleLogout(request, response, httpRequest, httpResponse, samlSessionStore);
            return false;
        }
        if (outcome == AuthOutcome.FAILED) {
            this.handleFailure(httpResponse);
            return false;
        }
        this.handleChallenge(request, httpFacade, samlAuthenticator);
        return false;
    }

    private void handleChallenge(ServletRequest request, ServletHttpFacade httpFacade, SamlAuthenticator samlAuthenticator) {
        AuthChallenge challenge = samlAuthenticator.getChallenge();
        if (challenge != null) {
            request.removeAttribute(DefaultSubjectContext.SESSION_CREATION_ENABLED);
            log.debug("Initiating SAML authentication via identity provider");
            challenge.challenge((HttpFacade)httpFacade);
        }
    }

    private void handleDisabled(HttpServletResponse httpResponse) {
        httpResponse.setStatus(500);
        httpResponse.setContentType(TEXT_PLAIN_CHARSET_UTF_8);
        httpResponse.setContentType(MSG_SAML_DISABLED);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (PrintWriter writer = httpResponse.getWriter();){
                writer.print(MSG_SAML_DISABLED);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.warn("Failed to write SAML disabled message to the response", (Throwable)e);
        }
    }

    private void handleFailure(HttpServletResponse httpResponse) {
        httpResponse.setStatus(500);
        httpResponse.setContentType(TEXT_PLAIN_CHARSET_UTF_8);
        httpResponse.setContentType(MSG_SAML_FAILURE);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (PrintWriter writer = httpResponse.getWriter();){
                writer.print(MSG_SAML_FAILURE);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.warn("Failed to write reason for failed authorization", (Throwable)e);
        }
    }

    private void handleLogout(ServletRequest request, ServletResponse response, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SamlSessionStore samlSessionStore) throws IOException {
        samlSessionStore.logoutAccount();
        this.getSubject(request, response).logout();
        String homePage = httpRequest.getContextPath();
        if (!homePage.endsWith("/")) {
            homePage = String.valueOf(homePage) + "/";
        }
        httpResponse.sendRedirect(homePage);
    }

    @VisibleForTesting
    static String getDestinationOrDefault(HttpServletRequest httpServletRequest) {
        String referer = httpServletRequest.getHeader("Referer");
        if (referer == null) {
            return String.valueOf(httpServletRequest.getRequestURL().substring(0, httpServletRequest.getRequestURL().length() - httpServletRequest.getRequestURI().length())) + "/";
        }
        return referer;
    }

    @VisibleForTesting
    SamlSessionStore newSamlSessionStore(HttpServletRequest httpRequest, HttpFacade httpFacade, SamlDeployment samlDeployment) {
        return new SamlSessionStoreForRedirect(httpRequest, httpFacade, 0, (SessionIdMapper)this.samlSessionManager.getIdMapper(), samlDeployment);
    }

    protected SamlAuthenticator newSamlAuthenticator(ServletHttpFacade httpFacade, SamlDeployment samlDeployment, SamlSessionStore samlSessionStore) {
        return new SamlAuthenticatorForSamlEndpoint((HttpFacade)httpFacade, samlDeployment, samlSessionStore);
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) {
        throw new IllegalStateException();
    }
}

