/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.saml.internal.SamlMetadataTool;
import com.sonatype.nexus.saml.persist.SamlConfigurationManager;
import com.sonatype.nexus.saml.persist.entity.SamlConfiguration;
import java.net.URI;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.keycloak.adapters.saml.DefaultSamlDeployment;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.PemUtils;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.IDPSSODescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.saml.SPMetadataDescriptor;
import org.keycloak.saml.SignatureAlgorithm;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.core.saml.v2.util.SAMLMetadataUtil;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.w3c.dom.Element;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class SamlDeploymentManager
extends LifecycleSupport {
    private static final int ALLOWED_CLOCK_SKEW_MILLISECONDS = 1000;
    private static final String XML_PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private static final String SAML_PATH = "saml";
    private final SamlMetadataTool samlMetadataTool;
    private final Provider<SamlConfigurationManager> samlConfigurationManager;
    private SamlDeployment samlDeployment;
    private Certificate certificate;

    @Inject
    public SamlDeploymentManager(SamlMetadataTool samlMetadataTool, Provider<SamlConfigurationManager> samlConfigurationManager) {
        this.samlMetadataTool = (SamlMetadataTool)Preconditions.checkNotNull((Object)samlMetadataTool);
        this.samlConfigurationManager = (Provider)Preconditions.checkNotNull(samlConfigurationManager);
    }

    protected void doStart() {
        try {
            this.updateFromConfiguration(((SamlConfigurationManager)this.samlConfigurationManager.get()).loadConfiguration());
        }
        catch (Exception e) {
            this.log.error("The SAML configuration is invalid and needs to be fixed by a system administrator", (Throwable)e);
        }
    }

    protected void doStop() {
        this.samlDeployment = null;
    }

    public void updateFromConfiguration(SamlConfiguration samlConfiguration) {
        this.samlDeployment = this.parse(samlConfiguration);
        this.log.info("SAML integration {}", (Object)(this.samlDeployment != null ? "enabled" : "disabled"));
    }

    public void clearSamlDeployment() {
        this.samlDeployment = null;
    }

    public SamlDeployment getSamlDeployment() {
        return this.samlDeployment;
    }

    @Nullable
    public SamlDeployment parse(SamlConfiguration samlConfiguration) {
        if (samlConfiguration == null) {
            return null;
        }
        EntityDescriptorType entityDescriptor = this.samlMetadataTool.parseEntityDescriptor(samlConfiguration.getIdpMetadata());
        IDPSSODescriptorType idpDescriptor = entityDescriptor.getChoiceType().stream().flatMap(choiceType -> choiceType.getDescriptors().stream()).map(EntityDescriptorType.EDTDescriptorChoiceType::getIdpDescriptor).filter(Objects::nonNull).findFirst().get();
        this.certificate = samlConfiguration.getCertificate();
        return this.buildDefaultSamlDeployment(samlConfiguration, this.buildIdp(samlConfiguration, idpDescriptor, entityDescriptor.getEntityID()));
    }

    private DefaultSamlDeployment buildDefaultSamlDeployment(SamlConfiguration samlConfiguration, DefaultSamlDeployment.DefaultIDP idp) {
        DefaultSamlDeployment defaultSamlDeployment = new DefaultSamlDeployment();
        defaultSamlDeployment.setEntityID(samlConfiguration.getEntityId());
        defaultSamlDeployment.setSslRequired(SslRequired.EXTERNAL);
        defaultSamlDeployment.setNameIDPolicyFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        defaultSamlDeployment.setForceAuthentication(false);
        defaultSamlDeployment.setIsPassive(false);
        defaultSamlDeployment.setTurnOffChangeSessionIdOnLogin(false);
        defaultSamlDeployment.setAutodetectBearerOnly(true);
        defaultSamlDeployment.setSignatureAlgorithm(SignatureAlgorithm.RSA_SHA256);
        defaultSamlDeployment.setSignatureCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#");
        defaultSamlDeployment.setSigningKeyPair(samlConfiguration.getSigningKeyPair());
        defaultSamlDeployment.setDecryptionKey(samlConfiguration.getDecryptionKey());
        defaultSamlDeployment.setRoleAttributeNames(Collections.emptySet());
        defaultSamlDeployment.setIdp((SamlDeployment.IDP)idp);
        return defaultSamlDeployment;
    }

    private DefaultSamlDeployment.DefaultIDP buildIdp(SamlConfiguration samlConfiguration, IDPSSODescriptorType idpDescriptor, String entityID) {
        DefaultSamlDeployment.DefaultIDP idp = new DefaultSamlDeployment.DefaultIDP();
        idp.setEntityID(entityID);
        List<PublicKey> keyDescriptors = this.getKeyDescriptorsForSigning(idpDescriptor).map(this::signatureValidationKey).collect(Collectors.toList());
        boolean hasKey = !keyDescriptors.isEmpty();
        keyDescriptors.forEach(arg_0 -> ((DefaultSamlDeployment.DefaultIDP)idp).addSignatureValidationKey(arg_0));
        boolean validateResponseSignature = Optional.ofNullable(samlConfiguration.getValidateResponseSignature()).orElse(hasKey);
        boolean validateAssertionSignature = Optional.ofNullable(samlConfiguration.getValidateAssertionSignature()).orElse(hasKey);
        this.log.debug("validateResponseSignature: {}, validateAssertionSignature: {}", (Object)validateResponseSignature, (Object)validateAssertionSignature);
        if (this.missingSigningKey(hasKey, validateResponseSignature, validateAssertionSignature)) {
            throw new IllegalArgumentException("SAML metadata for identity provider misses signing key to perform the requested signature validation");
        }
        idp.refreshKeyLocatorConfiguration();
        idp.setSingleSignOnService((SamlDeployment.IDP.SingleSignOnService)this.getDefaultSingleSignOnService(idpDescriptor, validateResponseSignature, validateAssertionSignature));
        idp.setAllowedClockSkew(1000);
        DefaultSamlDeployment.DefaultSingleLogoutService logoutService = this.getLogoutService(idpDescriptor, hasKey);
        if (logoutService != null) {
            idp.setSingleLogoutService((SamlDeployment.IDP.SingleLogoutService)logoutService);
        }
        return idp;
    }

    private PublicKey signatureValidationKey(KeyDescriptorType keyDescriptor) {
        X509Certificate signatureValidationCertificate;
        try {
            signatureValidationCertificate = SAMLMetadataUtil.getCertificate((KeyDescriptorType)keyDescriptor);
        }
        catch (ConfigurationException | ProcessingException e) {
            throw new IllegalArgumentException("SAML metadata for identity provider contains invalid certificate: " + e.getMessage(), e);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("SAML metadata for identity provider contains invalid certificate: Missing base64 data", e);
        }
        if (signatureValidationCertificate == null) {
            throw new IllegalArgumentException("SAML metadata for identity provider misses signing certificate");
        }
        return signatureValidationCertificate.getPublicKey();
    }

    private Stream<KeyDescriptorType> getKeyDescriptorsForSigning(IDPSSODescriptorType idpDescriptor) {
        return idpDescriptor.getKeyDescriptor().stream().filter(keyDescriptor -> keyDescriptor.getUse() == null || KeyTypes.SIGNING.equals((Object)keyDescriptor.getUse()));
    }

    private boolean missingSigningKey(boolean hasKey, boolean validateResponseSignature, boolean validateAssertionSignature) {
        return !hasKey && (validateResponseSignature || validateAssertionSignature);
    }

    private DefaultSamlDeployment.DefaultSingleSignOnService getDefaultSingleSignOnService(IDPSSODescriptorType idpDescriptor, boolean validateResponseSignature, boolean validateAssertionSignature) {
        EndpointType singleSignOnEndpoint = this.getEndpoint(idpDescriptor.getSingleSignOnService());
        DefaultSamlDeployment.DefaultSingleSignOnService singleSignOnService = new DefaultSamlDeployment.DefaultSingleSignOnService();
        singleSignOnService.setSignRequest(Optional.ofNullable(idpDescriptor.isWantAuthnRequestsSigned()).orElse(false).booleanValue());
        singleSignOnService.setValidateResponseSignature(validateResponseSignature);
        singleSignOnService.setValidateAssertionSignature(validateAssertionSignature);
        singleSignOnService.setRequestBindingUrl(singleSignOnEndpoint.getLocation().toString());
        singleSignOnService.setRequestBinding(this.getBinding(singleSignOnEndpoint));
        return singleSignOnService;
    }

    private DefaultSamlDeployment.DefaultSingleLogoutService getLogoutService(IDPSSODescriptorType idpDescriptor, boolean hasKey) {
        EndpointType singleLogoutEndpoint = this.getEndpoint(idpDescriptor.getSingleLogoutService());
        if (singleLogoutEndpoint == null) {
            return null;
        }
        DefaultSamlDeployment.DefaultSingleLogoutService singleLogoutService = new DefaultSamlDeployment.DefaultSingleLogoutService();
        singleLogoutService.setSignRequest(Optional.ofNullable(idpDescriptor.isWantAuthnRequestsSigned()).orElse(true).booleanValue());
        singleLogoutService.setSignResponse(singleLogoutService.signRequest());
        singleLogoutService.setValidateRequestSignature(hasKey);
        singleLogoutService.setValidateResponseSignature(hasKey);
        singleLogoutService.setRequestBindingUrl(singleLogoutEndpoint.getLocation().toString());
        singleLogoutService.setRequestBinding(this.getBinding(singleLogoutEndpoint));
        singleLogoutService.setResponseBindingUrl(singleLogoutEndpoint.getLocation().toString());
        singleLogoutService.setResponseBinding(this.getBinding(singleLogoutEndpoint));
        return singleLogoutService;
    }

    private EndpointType getEndpoint(List<EndpointType> endpoints) {
        EndpointType postEndpoint = null;
        EndpointType redirectEndpoint = null;
        for (EndpointType endpoint : endpoints) {
            if (SamlMetadataTool.POST_BINDING.equals(endpoint.getBinding())) {
                postEndpoint = endpoint;
                continue;
            }
            if (!SamlMetadataTool.REDIRECT_BINDING.equals(endpoint.getBinding())) continue;
            redirectEndpoint = endpoint;
        }
        return postEndpoint != null ? postEndpoint : redirectEndpoint;
    }

    private SamlDeployment.Binding getBinding(EndpointType endpoint) {
        if (SamlMetadataTool.POST_BINDING.equals(endpoint.getBinding())) {
            return SamlDeployment.Binding.POST;
        }
        if (SamlMetadataTool.REDIRECT_BINDING.equals(endpoint.getBinding())) {
            return SamlDeployment.Binding.REDIRECT;
        }
        return null;
    }

    public Optional<String> getMetadata() {
        if (this.samlDeployment == null) {
            return Optional.empty();
        }
        String samlEndpointUrl = UriBuilder.fromUri((String)BaseUrlHolder.get()).path(SAML_PATH).build(new Object[0]).toString();
        String metadata = null;
        try {
            ArrayList<Element> signingCerts = new ArrayList<Element>();
            signingCerts.add(SPMetadataDescriptor.buildKeyInfoElement((String)KeyTypes.SIGNING.value(), (String)PemUtils.encodeCertificate((Certificate)this.certificate)));
            ArrayList<Element> encryptionCerts = new ArrayList<Element>();
            encryptionCerts.add(SPMetadataDescriptor.buildKeyInfoElement((String)KeyTypes.ENCRYPTION.value(), (String)PemUtils.encodeCertificate((Certificate)this.certificate)));
            metadata = XML_PROLOG + SPMetadataDescriptor.getSPDescriptor((URI)URI.create(JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get()), (URI)URI.create(samlEndpointUrl), (URI)URI.create(samlEndpointUrl), (boolean)this.samlDeployment.getIDP().getSingleSignOnService().signRequest(), (boolean)this.samlDeployment.getIDP().getSingleSignOnService().validateAssertionSignature(), (boolean)true, (String)this.samlDeployment.getEntityID(), (String)this.samlDeployment.getNameIDPolicyFormat(), signingCerts, encryptionCerts);
        }
        catch (ParserConfigurationException | XMLStreamException | ProcessingException ex) {
            this.log.error("Error obtaining SPDescriptor ", ex);
        }
        return Optional.of(metadata);
    }

    public Optional<String> getPublicCertificateInPemFormat() {
        if (this.samlDeployment == null) {
            return Optional.empty();
        }
        return Optional.of(PemUtils.encodeCertificate((Certificate)this.certificate));
    }
}

