/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.saml.internal.JwtSamlAuthenticatorForSamlEndpoint;
import com.sonatype.nexus.saml.internal.SamlDeploymentManager;
import com.sonatype.nexus.saml.internal.SamlFilter;
import com.sonatype.nexus.saml.internal.SamlSessionManager;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.keycloak.adapters.saml.SamlAuthenticator;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.servlet.ServletHttpFacade;
import org.keycloak.adapters.spi.HttpFacade;
import org.sonatype.nexus.security.JwtHelper;

@Named
@Singleton
public class JwtSamlFilter
extends SamlFilter {
    private final JwtHelper jwtHelper;

    @Inject
    public JwtSamlFilter(SamlDeploymentManager samlDeploymentManager, SamlSessionManager samlSessionManager, JwtHelper jwtHelper) {
        super(samlDeploymentManager, samlSessionManager);
        this.jwtHelper = (JwtHelper)Preconditions.checkNotNull((Object)jwtHelper);
    }

    @Override
    protected SamlAuthenticator newSamlAuthenticator(ServletHttpFacade httpFacade, SamlDeployment samlDeployment, SamlSessionStore samlSessionStore) {
        return new JwtSamlAuthenticatorForSamlEndpoint((HttpFacade)httpFacade, samlDeployment, samlSessionStore, this.jwtHelper);
    }
}

