/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.api.model;

import com.sonatype.nexus.saml.persist.entity.Mapping;
import com.sonatype.nexus.saml.persist.entity.SamlConfiguration;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import org.sonatype.nexus.validation.constraint.UriString;

public class SamlConfigurationXO {
    @UriString
    @ApiModelProperty(value="SAML Service Provider's unique identifying URI", required=false)
    private String entityId;
    @NotBlank
    @ApiModelProperty(value="SAML Identity Provider Metadata XML", required=true)
    private String idpMetadata;
    @NotBlank
    @ApiModelProperty(value="SAML attribute name for the username", required=true)
    private String usernameAttribute;
    @ApiModelProperty(value="SAML attribute name for the first name")
    private String firstNameAttribute;
    @ApiModelProperty(value="SAML attribute name for the last name")
    private String lastNameAttribute;
    @ApiModelProperty(value="SAML attribute name for email")
    private String emailAttribute;
    @ApiModelProperty(value="SAML attribute name for groups which maps the Identity Provider groups to a Nexus Repository Manager role")
    private String groupsAttribute;
    @ApiModelProperty(value="Validate signatures on responses from Identity Provider")
    private Boolean validateResponseSignature;
    @ApiModelProperty(value="Validate signatures on assertions from Identity Provider")
    private Boolean validateAssertionSignature;

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getIdpMetadata() {
        return this.idpMetadata;
    }

    public void setIdpMetadata(String idpMetadata) {
        this.idpMetadata = idpMetadata;
    }

    public String getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    public String getFirstNameAttribute() {
        return this.firstNameAttribute;
    }

    public void setFirstNameAttribute(String firstNameAttribute) {
        this.firstNameAttribute = firstNameAttribute;
    }

    public String getLastNameAttribute() {
        return this.lastNameAttribute;
    }

    public void setLastNameAttribute(String lastNameAttribute) {
        this.lastNameAttribute = lastNameAttribute;
    }

    public String getEmailAttribute() {
        return this.emailAttribute;
    }

    public void setEmailAttribute(String emailAttribute) {
        this.emailAttribute = emailAttribute;
    }

    public String getGroupsAttribute() {
        return this.groupsAttribute;
    }

    public void setGroupsAttribute(String groupsAttribute) {
        this.groupsAttribute = groupsAttribute;
    }

    public Boolean getValidateResponseSignature() {
        return this.validateResponseSignature;
    }

    public void setValidateResponseSignature(Boolean validateResponseSignature) {
        this.validateResponseSignature = validateResponseSignature;
    }

    public Boolean getValidateAssertionSignature() {
        return this.validateAssertionSignature;
    }

    public void setValidateAssertionSignature(Boolean validateAssertionSignature) {
        this.validateAssertionSignature = validateAssertionSignature;
    }

    public static SamlConfiguration toSamlConfiguration(SamlConfigurationXO configurationXO, SamlConfiguration configuration) {
        if (configurationXO.getEntityId() != null) {
            configuration.setEntityId(configurationXO.getEntityId());
        }
        configuration.setIdpMetadata(configurationXO.getIdpMetadata());
        configuration.setValidateResponseSignature(configurationXO.getValidateResponseSignature());
        configuration.setValidateAssertionSignature(configurationXO.getValidateAssertionSignature());
        Mapping mapping = new Mapping();
        mapping.setUsernameAttributeName(configurationXO.getUsernameAttribute());
        mapping.setEmailAttributeName(configurationXO.getEmailAttribute());
        mapping.setFirstNameAttributeName(configurationXO.getFirstNameAttribute());
        mapping.setLastNameAttributeName(configurationXO.getLastNameAttribute());
        mapping.setGroupsAttributeName(configurationXO.getGroupsAttribute());
        configuration.setMapping(mapping);
        return configuration;
    }

    public static SamlConfigurationXO toSamlConfigurationXO(SamlConfiguration configuration) {
        SamlConfigurationXO configurationXO = new SamlConfigurationXO();
        configurationXO.setEntityId(configuration.getEntityId());
        configurationXO.setIdpMetadata(configuration.getIdpMetadata());
        configurationXO.setValidateResponseSignature(configuration.getValidateResponseSignature());
        configurationXO.setValidateAssertionSignature(configuration.getValidateAssertionSignature());
        Mapping mapping = configuration.getMapping();
        configurationXO.setUsernameAttribute(mapping.getUsernameAttributeName());
        configurationXO.setEmailAttribute(mapping.getEmailAttributeName());
        configurationXO.setFirstNameAttribute(mapping.getFirstNameAttributeName());
        configurationXO.setLastNameAttribute(mapping.getLastNameAttributeName());
        configurationXO.setGroupsAttribute(mapping.getGroupsAttributeName());
        return configurationXO;
    }
}

