/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.licensing.internal;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.MemorySecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityContributor;
import org.sonatype.nexus.security.config.SecurityContributorSupport;

@Named
@Singleton
public class LicensingSecurityContributor
extends SecurityContributorSupport
implements SecurityContributor {
    public static final String LICENSING_DOMAIN = "licensing";
    public static final String LICENSING_ALL_PRIV_ID = "nx-licensing-all";
    public static final String LICENSING_CREATE_PRIV_ID = "nx-licensing-create";
    public static final String LICENSING_READ_PRIV_ID = "nx-licensing-read";
    public static final String LICENSING_UNINSTALL_PRIV_ID = "nx-licensing-uninstall";
    public static final String LICENSING_UNINSTALL_PRIV_DESCRIPTION = "Uninstall permission for Licensing";

    public SecurityConfiguration getContribution() {
        MemorySecurityConfiguration config = new MemorySecurityConfiguration();
        config.addPrivilege((CPrivilege)this.createApplicationPrivilege(LICENSING_ALL_PRIV_ID, "All permissions for " + StringUtils.capitalize((String)LICENSING_DOMAIN), LICENSING_DOMAIN, "*"));
        config.addPrivilege((CPrivilege)this.createApplicationPrivilege(LICENSING_CREATE_PRIV_ID, "Create permission for " + StringUtils.capitalize((String)LICENSING_DOMAIN), LICENSING_DOMAIN, "create,read"));
        config.addPrivilege((CPrivilege)this.createApplicationPrivilege(LICENSING_READ_PRIV_ID, "Read permission for " + StringUtils.capitalize((String)LICENSING_DOMAIN), LICENSING_DOMAIN, "read"));
        config.addPrivilege((CPrivilege)this.createApplicationPrivilege(LICENSING_UNINSTALL_PRIV_ID, LICENSING_UNINSTALL_PRIV_DESCRIPTION, LICENSING_DOMAIN, "delete"));
        return config;
    }
}

