/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.licensing.internal;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.sonatype.nexus.licensing.ext.LicenseManager;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.licensing.LicensingException;
import org.sonatype.licensing.product.ProductLicenseKey;

@Named
@Singleton
public class LicenseUtil {
    private static final Logger log = LoggerFactory.getLogger(LicenseUtil.class);
    private final LicenseManager licenseManager;

    @Inject
    public LicenseUtil(LicenseManager licenseManager) {
        this.licenseManager = (LicenseManager)Preconditions.checkNotNull((Object)licenseManager);
    }

    void install(InputStream in) {
        try {
            this.install(ByteStreams.toByteArray((InputStream)in));
        }
        catch (IOException e) {
            log.error("Unable to handle license content properly.", (Throwable)e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public void install(byte[] licenseBytes) {
        try {
            this.licenseManager.installLicense(licenseBytes);
        }
        catch (IOException e) {
            log.error("Unable to handle license content properly.", (Throwable)e);
            throw new InternalServerErrorException((Throwable)e);
        }
        catch (LicensingException e) {
            log.error("Invalid license.", (Throwable)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    public void uninstallLicense() {
        this.licenseManager.uninstallLicense();
    }

    public String getFingerprint() {
        return this.licenseManager.getLicenseFingerprint();
    }

    public ProductLicenseKey getLicenseDetails() {
        return this.licenseManager.getLicenseDetails();
    }

    public ProductLicenseKey getLicenseDetails(InputStream inputStream) throws IOException {
        return this.licenseManager.getLicenseDetails(inputStream);
    }
}

