/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.transaction;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.sonatype.nexus.transaction.Transaction;
import org.sonatype.nexus.transaction.TransactionalSession;
import org.sonatype.nexus.transaction.TransactionalStore;

public final class UnitOfWork
implements TransactionalSession<Transaction> {
    private static final ThreadLocal<UnitOfWork> CURRENT_WORK = new ThreadLocal();
    @Nullable
    private final UnitOfWork parent;
    private final TransactionalStore<?> store;
    private final Scope scope;
    @Nullable
    TransactionalSession<?> session;

    private UnitOfWork(UnitOfWork parent, TransactionalStore<?> store, Scope scope) {
        this.parent = parent;
        this.store = (TransactionalStore)Preconditions.checkNotNull(store);
        this.scope = (Scope)((Object)Preconditions.checkNotNull((Object)((Object)scope)));
    }

    public static void begin(Supplier<? extends TransactionalSession<?>> db) {
        Preconditions.checkNotNull(db);
        UnitOfWork.doBegin(db::get, Scope.TRANSACTIONAL);
    }

    public static void beginBatch(Supplier<? extends TransactionalSession<?>> db) {
        Preconditions.checkNotNull(db);
        UnitOfWork.doBegin(db::get, Scope.UNIT_OF_WORK);
    }

    public static void beginBatch(TransactionalSession<?> session) {
        Preconditions.checkNotNull(session);
        UnitOfWork.doBegin(() -> session, Scope.UNIT_OF_WORK);
        UnitOfWork.currentWork().session = session;
    }

    public static void end() {
        UnitOfWork.currentWork().doEnd();
    }

    public static <S extends TransactionalSession<?>> S currentSession() {
        TransactionalSession<?> session = UnitOfWork.currentWork().session;
        Preconditions.checkState((session != null ? 1 : 0) != 0, (Object)"No transactional session");
        return (S)session;
    }

    public static <T extends Transaction> T currentTx() {
        Transaction tx = UnitOfWork.currentWork().getTransaction();
        Preconditions.checkState((tx != null ? 1 : 0) != 0, (Object)"No transaction in progress");
        return (T)tx;
    }

    @Nullable
    public static UnitOfWork pause() {
        UnitOfWork pausedWork = CURRENT_WORK.get();
        CURRENT_WORK.remove();
        return pausedWork;
    }

    public static void resume(@Nullable UnitOfWork pausedWork) {
        Preconditions.checkState((CURRENT_WORK.get() == null ? 1 : 0) != 0, (Object)"Cannot resume unit-of-work while other work is ongoing");
        if (pausedWork != null) {
            CURRENT_WORK.set(pausedWork);
        }
    }

    @Override
    public Transaction getTransaction() {
        if (this.session instanceof Transaction) {
            return (Transaction)((Object)this.session);
        }
        if (this.session != null) {
            return this.session.getTransaction();
        }
        return null;
    }

    @Override
    public void close() {
        if (this.scope == Scope.LOCAL_STORE) {
            this.popWork();
        }
        if (this.scope != Scope.UNIT_OF_WORK) {
            this.doCloseSession();
        }
    }

    @Nullable
    static Transaction peekTransaction() {
        UnitOfWork currentWork = CURRENT_WORK.get();
        return currentWork != null ? currentWork.getTransaction() : null;
    }

    static TransactionalSession<?> openSession(@Nullable TransactionalStore<?> localStore) {
        UnitOfWork currentWork = CURRENT_WORK.get();
        if (localStore != null && (currentWork == null || currentWork.scope == Scope.UNIT_OF_WORK)) {
            currentWork = new UnitOfWork(currentWork, localStore, Scope.LOCAL_STORE);
            CURRENT_WORK.set(currentWork);
        } else {
            Preconditions.checkState((currentWork != null ? 1 : 0) != 0, (Object)"Unit of work has not been set");
        }
        return currentWork.doOpenSession(localStore);
    }

    private static UnitOfWork currentWork() {
        UnitOfWork currentWork = CURRENT_WORK.get();
        Preconditions.checkState((currentWork != null ? 1 : 0) != 0, (Object)"Unit of work has not been set");
        return currentWork;
    }

    private static void doBegin(TransactionalStore<?> store, Scope scope) {
        UnitOfWork parent = CURRENT_WORK.get();
        Preconditions.checkState((parent == null || parent.session == null ? 1 : 0) != 0, (Object)"Transaction in progress, pause current unit-of-work before beginning new work");
        CURRENT_WORK.set(new UnitOfWork(parent, store, scope));
    }

    private TransactionalSession<?> doOpenSession(@Nullable TransactionalStore<?> localStore) {
        if (this.session == null) {
            this.session = (TransactionalSession)Preconditions.checkNotNull(localStore != null ? localStore.openSession() : this.store.openSession());
        }
        return this;
    }

    private void doCloseSession() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            finally {
                this.session = null;
            }
        }
    }

    private void doEnd() {
        if (this.scope != Scope.UNIT_OF_WORK) {
            Preconditions.checkState((this.session == null ? 1 : 0) != 0, (Object)"Cannot end unit-of-work while transaction in progress");
        }
        this.popWork();
        this.doCloseSession();
    }

    private void popWork() {
        if (this.parent != null) {
            CURRENT_WORK.set(this.parent);
        } else {
            CURRENT_WORK.remove();
        }
    }

    static enum Scope {
        TRANSACTIONAL,
        UNIT_OF_WORK,
        LOCAL_STORE;

    }
}

