/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.transaction;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.Joinpoint;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.transaction.Transaction;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.TransactionalSession;
import org.sonatype.nexus.transaction.TransactionalStore;
import org.sonatype.nexus.transaction.TransactionalWrapper;
import org.sonatype.nexus.transaction.UnitOfWork;

final class TransactionInterceptor
extends ComponentSupport
implements MethodInterceptor {
    TransactionInterceptor() {
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        Transaction tx;
        TransactionalStore store = null;
        if (mi.getThis() instanceof TransactionalStore) {
            store = (TransactionalStore)mi.getThis();
        }
        if ((tx = UnitOfWork.peekTransaction()) != null) {
            if (store != null) {
                tx.capture(store);
            }
            if (tx.isActive()) {
                return mi.proceed();
            }
            return this.proceedWithTransaction(mi, tx);
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (TransactionalSession<?> session = UnitOfWork.openSession(store);){
            return this.proceedWithTransaction(mi, (Transaction)session.getTransaction());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Object proceedWithTransaction(MethodInvocation mi, Transaction tx) throws Throwable {
        Method method = mi.getMethod();
        Transactional spec = TransactionInterceptor.findSpec(method);
        this.log.trace("Invoking: {} -> {}", (Object)spec, (Object)method);
        return new TransactionalWrapper(spec, (Joinpoint)mi).proceedWithTransaction(tx);
    }

    private static final Transactional findSpec(Method method) {
        Transactional spec = method.getAnnotation(Transactional.class);
        if (spec != null) {
            return spec;
        }
        Annotation[] annotationArray = method.getDeclaredAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            spec = ann.annotationType().getAnnotation(Transactional.class);
            if (spec != null) {
                return spec;
            }
            ++n2;
        }
        throw new IllegalStateException("Missing @Transactional on: " + method);
    }
}

