/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.transaction;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.SplittableRandom;
import java.util.concurrent.TimeUnit;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.common.sequence.ThreadLocalSplittableRandom;
import org.sonatype.nexus.transaction.ExceptionFilter;
import org.sonatype.nexus.transaction.RollingStats;

public class RetryController
extends ComponentSupport {
    private static final ThreadLocalSplittableRandom randomHolder = new ThreadLocalSplittableRandom();
    private static final int DEFAULT_RETRY_LIMIT = 8;
    private static final int DEFAULT_MIN_SLOTS = 2;
    private static final int DEFAULT_MAX_SLOTS = 256;
    private static final Time DEFAULT_MINOR_DELAY_MILLIS = Time.millis((long)10L);
    private static final Time DEFAULT_MAJOR_DELAY_MILLIS = Time.millis((long)100L);
    public static final RetryController INSTANCE = new RetryController();
    private final RollingStats excessiveRetriesHourlyStats = new RollingStats(60, TimeUnit.MINUTES);
    private int retryLimit = SystemPropertiesHelper.getInteger((String)"nexus.tx.retry.limit", (int)8);
    private int minSlots = SystemPropertiesHelper.getInteger((String)"nexus.tx.retry.minSlots", (int)2);
    private int maxSlots = SystemPropertiesHelper.getInteger((String)"nexus.tx.retry.maxSlots", (int)256);
    private int minorDelayMillis = SystemPropertiesHelper.getTime((String)"nexus.tx.retry.minorDelay", (Time)DEFAULT_MINOR_DELAY_MILLIS).toMillisI();
    private int majorDelayMillis = SystemPropertiesHelper.getTime((String)"nexus.tx.retry.majorDelay", (Time)DEFAULT_MAJOR_DELAY_MILLIS).toMillisI();
    private final ExceptionFilter majorExceptionFilter = new ExceptionFilter(SystemPropertiesHelper.getString((String)"nexus.tx.retry.majorExceptionFilter", (String)IOException.class.getName()));
    private final ExceptionFilter noisyExceptionFilter = new ExceptionFilter(SystemPropertiesHelper.getString((String)"nexus.tx.retry.noisyExceptionFilter", (String)""));
    private int excessiveRetriesThreshold;

    public RetryController() {
        this.updateExcessiveRetriesThreshold();
    }

    public int getRetryLimit() {
        return this.retryLimit;
    }

    public void setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
        this.updateExcessiveRetriesThreshold();
    }

    public int getMinSlots() {
        return this.minSlots;
    }

    public void setMinSlots(int minSlots) {
        Preconditions.checkArgument((minSlots >= 0 ? 1 : 0) != 0);
        this.minSlots = minSlots;
    }

    public int getMaxSlots() {
        return this.maxSlots;
    }

    public void setMaxSlots(int maxSlots) {
        Preconditions.checkArgument((maxSlots >= 0 ? 1 : 0) != 0);
        this.maxSlots = maxSlots;
    }

    public int getMinorDelayMillis() {
        return this.minorDelayMillis;
    }

    public void setMinorDelayMillis(int minorDelayMillis) {
        Preconditions.checkArgument((minorDelayMillis >= 0 ? 1 : 0) != 0);
        this.minorDelayMillis = minorDelayMillis;
    }

    public int getMajorDelayMillis() {
        return this.majorDelayMillis;
    }

    public void setMajorDelayMillis(int majorDelayMillis) {
        Preconditions.checkArgument((majorDelayMillis >= 0 ? 1 : 0) != 0);
        this.majorDelayMillis = majorDelayMillis;
    }

    public ExceptionFilter majorExceptionFilter() {
        return this.majorExceptionFilter;
    }

    public ExceptionFilter noisyExceptionFilter() {
        return this.noisyExceptionFilter;
    }

    public boolean allowRetry(int retriesSoFar, Exception cause) {
        int nextRetry = retriesSoFar + 1;
        if (nextRetry > this.retryLimit) {
            if (this.log.isTraceEnabled()) {
                this.log.warn("Exceeded retry limit: {}/{}", new Object[]{retriesSoFar, this.retryLimit, cause});
            } else {
                this.log.warn("Exceeded retry limit: {}/{} ({})", new Object[]{retriesSoFar, this.retryLimit, cause.toString()});
            }
            return false;
        }
        if (nextRetry == this.excessiveRetriesThreshold && !this.noisyExceptionFilter.test(cause)) {
            this.excessiveRetriesHourlyStats.mark();
        }
        long delay = this.randomDelay(nextRetry, cause);
        if (this.log.isTraceEnabled()) {
            this.log.debug("Allowing retry: {}/{} in {}ms", new Object[]{nextRetry, this.retryLimit, delay, cause});
        } else {
            this.log.debug("Allowing retry: {}/{} in {}ms ({})", new Object[]{nextRetry, this.retryLimit, delay, cause.toString()});
        }
        this.backoff(delay);
        return true;
    }

    public long excessiveRetriesInLastHour() {
        return this.excessiveRetriesHourlyStats.sum();
    }

    private void updateExcessiveRetriesThreshold() {
        this.excessiveRetriesThreshold = (this.retryLimit >> 1) + 1;
    }

    @VisibleForTesting
    protected void backoff(long delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private long randomDelay(int nextRetry, Exception cause) {
        int slots = Math.min(Math.max(1 << nextRetry, this.minSlots), this.maxSlots);
        int randomSlot = ((SplittableRandom)randomHolder.get()).nextInt(slots);
        if (this.majorExceptionFilter.test(cause)) {
            return this.majorDelayMillis * (randomSlot + 1);
        }
        return this.minorDelayMillis * randomSlot;
    }
}

