/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.transaction;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.transaction.Operation;
import org.sonatype.nexus.transaction.OperationPoint;
import org.sonatype.nexus.transaction.Transaction;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.TransactionalImpl;
import org.sonatype.nexus.transaction.TransactionalSession;
import org.sonatype.nexus.transaction.TransactionalStore;
import org.sonatype.nexus.transaction.TransactionalWrapper;
import org.sonatype.nexus.transaction.UnitOfWork;
import org.sonatype.nexus.transaction.VoidOperation;

public class Operations<E extends Exception, B extends Operations<E, B>> {
    private static final Logger log = LoggerFactory.getLogger(Operations.class);
    private static final Class<?>[] NOTHING = new Class[0];
    @VisibleForTesting
    static final Transactional DEFAULT_SPEC = new TransactionalImpl("transaction", NOTHING, NOTHING, NOTHING);
    @VisibleForTesting
    final Transactional spec;
    @Nullable
    private final Class<E> throwing;
    @Nullable
    private final TransactionalStore<?> store;

    public final B reason(String reason) {
        return (B)this.copy(new TransactionalImpl(reason, this.spec.commitOn(), this.spec.retryOn(), this.spec.swallow()), this.throwing, this.store);
    }

    @SafeVarargs
    public final B commitOn(Class<? extends Exception> ... exceptionTypes) {
        Class[] commitOn = (Class[])Operations.deepCheckNotNull(exceptionTypes).clone();
        return (B)this.copy(new TransactionalImpl(this.spec.reason(), commitOn, this.spec.retryOn(), this.spec.swallow()), this.throwing, this.store);
    }

    @SafeVarargs
    public final B retryOn(Class<? extends Exception> ... exceptionTypes) {
        Class[] retryOn = (Class[])Operations.deepCheckNotNull(exceptionTypes).clone();
        return (B)this.copy(new TransactionalImpl(this.spec.reason(), this.spec.commitOn(), retryOn, this.spec.swallow()), this.throwing, this.store);
    }

    @SafeVarargs
    public final B swallow(Class<? extends Exception> ... exceptionTypes) {
        Class[] swallow = (Class[])Operations.deepCheckNotNull(exceptionTypes).clone();
        return (B)this.copy(new TransactionalImpl(this.spec.reason(), this.spec.commitOn(), this.spec.retryOn(), swallow), this.throwing, this.store);
    }

    public final B stereotype(Class<? extends Annotation> annotationType) {
        Transactional metaSpec = annotationType.getAnnotation(Transactional.class);
        Preconditions.checkArgument((metaSpec != null ? 1 : 0) != 0, (Object)"Stereotype annotation is not meta-annotated with @Transactional");
        return (B)this.copy(metaSpec, this.throwing, this.store);
    }

    public <X extends Exception> Operations<X, ?> throwing(Class<X> exceptionType) {
        return this.copy(this.spec, (Class)Preconditions.checkNotNull(exceptionType), this.store);
    }

    public final B withDb(Supplier<? extends TransactionalSession<?>> db) {
        return (B)this.copy(this.spec, this.throwing, db::get);
    }

    public final B withStore(TransactionalStore<?> _store) {
        return (B)this.copy(this.spec, this.throwing, (TransactionalStore)Preconditions.checkNotNull(_store));
    }

    public final <T> T call(Operation<T, E> operation) throws E {
        return this.transactional(new OperationPoint<T, E>(operation));
    }

    public final void run(VoidOperation<E> operation) throws E {
        this.transactional(new OperationPoint(operation));
    }

    protected Operations() {
        this(DEFAULT_SPEC, null, null);
    }

    protected Operations(Transactional spec, @Nullable Class<E> throwing, @Nullable TransactionalStore<?> store) {
        this.spec = (Transactional)Preconditions.checkNotNull((Object)spec);
        this.throwing = throwing;
        this.store = store;
    }

    protected <X extends Exception> Operations<X, ?> copy(Transactional spec, @Nullable Class<X> throwing, @Nullable TransactionalStore<?> store) {
        return new Operations<X, B>(spec, throwing, store);
    }

    private <T> T transactional(OperationPoint<T, E> point) throws E {
        Transaction tx = UnitOfWork.peekTransaction();
        if (tx != null) {
            if (this.store != null) {
                tx.capture(this.store);
            }
            if (tx.isActive()) {
                return point.proceed();
            }
            return this.proceedWithTransaction(point, tx);
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (TransactionalSession<?> session = UnitOfWork.openSession(this.store);){
            return this.proceedWithTransaction(point, (Transaction)session.getTransaction());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private <T> T proceedWithTransaction(OperationPoint<T, E> point, Transaction tx) throws E {
        log.trace("Invoking: {} -> {}", (Object)this.spec, point);
        try {
            return (T)new TransactionalWrapper(this.spec, point).proceedWithTransaction(tx);
        }
        catch (Throwable e) {
            if (this.throwing != null) {
                Throwables.propagateIfPossible((Throwable)e, this.throwing);
            }
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static <T> T[] deepCheckNotNull(T[] elements) {
        T[] TArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            T e = TArray[n2];
            Preconditions.checkNotNull(e);
            ++n2;
        }
        return elements;
    }
}

