/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.transaction;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ExceptionFilter
implements Predicate<Exception> {
    private ImmutableSet<String> filter;

    public ExceptionFilter(String exceptionFilter) {
        this.filter = ExceptionFilter.parseFilter(exceptionFilter);
    }

    @Override
    public boolean test(Exception cause) {
        return this.filter.contains((Object)cause.getClass().getName());
    }

    public String getFilterString() {
        return this.filter.stream().collect(Collectors.joining(","));
    }

    public void setFilterString(String filterString) {
        this.filter = ExceptionFilter.parseFilter(filterString);
    }

    public void addException(Class<? extends Exception> type) {
        this.filter = Sets.union(this.filter, (Set)ImmutableSet.of((Object)type.getName())).immutableCopy();
    }

    public void removeException(Class<? extends Exception> type) {
        this.filter = Sets.difference(this.filter, (Set)ImmutableSet.of((Object)type.getName())).immutableCopy();
    }

    private static ImmutableSet<String> parseFilter(String filterString) {
        return ImmutableSet.copyOf((Object[])filterString.split("\\s*,\\s*"));
    }
}

