/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.edition.pro;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.licensing.ext.LicenseChangedEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.licensing.feature.FeatureSet;
import org.sonatype.licensing.product.ProductLicenseKey;
import org.sonatype.licensing.product.util.LicenseContent;
import org.sonatype.licensing.product.util.LicenseFingerprinter;
import org.sonatype.nexus.common.app.ApplicationLicense;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.time.DateHelper;

@Named(value="PRO")
@Singleton
public class ApplicationLicenseImpl
extends ComponentSupport
implements ApplicationLicense,
EventAware {
    private final LicenseFingerprinter fingerprinter;
    private final List<Feature> availableFeatures;
    private final LicenseContent licenseContent;
    private volatile ProductLicenseKey licenseKey;
    private volatile Map<String, Object> attributes;
    private volatile String fingerprint;

    @Inject
    public ApplicationLicenseImpl(LicenseFingerprinter fingerprinter, List<Feature> availableFeatures, LicenseContent licenseContent) {
        this.fingerprinter = (LicenseFingerprinter)Preconditions.checkNotNull((Object)fingerprinter);
        this.availableFeatures = (List)Preconditions.checkNotNull(availableFeatures);
        this.licenseContent = (LicenseContent)Preconditions.checkNotNull((Object)licenseContent);
        this.refresh();
    }

    private void setLicenseKey(ProductLicenseKey licenseKey) {
        this.licenseKey = licenseKey;
        this.fingerprint = null;
        this.attributes = null;
        this.log.debug("License key: {}", (Object)licenseKey);
    }

    public boolean isRequired() {
        return true;
    }

    public boolean isValid() {
        return this.isInstalled() && !this.isExpired();
    }

    public boolean isEvaluation() {
        return this.isValid() && this.licenseKey.isEvaluation();
    }

    public boolean isInstalled() {
        return this.licenseKey != null;
    }

    public boolean isExpired() {
        return !this.isInstalled() || new Date().after(this.licenseKey.getExpirationDate());
    }

    public Map<String, Object> getAttributes() {
        if (this.attributes == null && this.licenseKey != null) {
            LinkedHashMap<String, Object> attrs = new LinkedHashMap<String, Object>();
            attrs.put(ApplicationLicense.Attributes.EVAL.getKey(), this.licenseKey.isEvaluation());
            attrs.put(ApplicationLicense.Attributes.USERS.getKey(), this.licenseKey.getLicensedUsers());
            attrs.put(ApplicationLicense.Attributes.FEATURES.getKey(), Collections.unmodifiableList(this.licenseKey.getRawFeatures()));
            attrs.put(ApplicationLicense.Attributes.EFFECTIVE_FEATURES.getKey(), this.effectiveFeatures(this.licenseKey));
            attrs.put(ApplicationLicense.Attributes.EFFECTIVE_DATE.getKey(), DateHelper.copy((Date)this.licenseKey.getEffectiveDate()));
            attrs.put(ApplicationLicense.Attributes.EXPIRATION_DATE.getKey(), DateHelper.copy((Date)this.licenseKey.getExpirationDate()));
            attrs.put(ApplicationLicense.Attributes.CONTACT_NAME.getKey(), this.licenseKey.getContactName());
            attrs.put(ApplicationLicense.Attributes.CONTACT_EMAIL.getKey(), this.licenseKey.getContactEmailAddress());
            attrs.put(ApplicationLicense.Attributes.CONTACT_COMPANY.getKey(), this.licenseKey.getContactCompany());
            attrs.put(ApplicationLicense.Attributes.CONTACT_COUNTRY.getKey(), this.licenseKey.getContactCountry());
            this.attributes = Collections.unmodifiableMap(attrs);
        }
        return this.attributes;
    }

    private List<String> effectiveFeatures(ProductLicenseKey key) {
        FeatureSet featureSet = key.getFeatureSet();
        ArrayList<String> result = new ArrayList<String>();
        for (Feature feature : this.availableFeatures) {
            if (!featureSet.hasFeature(feature)) continue;
            result.add(feature.getId());
        }
        return Collections.unmodifiableList(result);
    }

    @Nullable
    public String getFingerprint() {
        if (this.fingerprint == null && this.licenseKey != null) {
            this.fingerprint = this.fingerprinter.calculate(this.licenseKey);
        }
        return this.fingerprint;
    }

    public final void refresh() {
        this.setLicenseKey(this.licenseContent.key());
    }

    @Subscribe
    public void on(LicenseChangedEvent event) {
        this.setLicenseKey(event.getLicenseKey());
    }
}

