/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.logging.task;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.sift.SiftingAppender;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.rolling.RollingFileAppender;
import java.io.File;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

public class TaskLogHome {
    private static final Logger log = LoggerFactory.getLogger(TaskLogHome.class);

    private TaskLogHome() {
        throw new IllegalAccessError("Utility class");
    }

    @Nullable
    public static String getTaskLogHome() {
        LoggerContext loggerContext = (LoggerContext)StaticLoggerBinder.getSingleton().getLoggerFactory();
        Appender appender = loggerContext.getLogger("ROOT").getAppender("tasklogfile");
        if (!(appender instanceof SiftingAppender) && !(appender instanceof RollingFileAppender)) {
            log.warn("Could not find a Logback SiftingAppender or RollingFileAppender named 'tasklogfile' in the logback configuration. Please check that the 'tasklogfile' appender exists in logback.xml");
            return null;
        }
        if (appender instanceof RollingFileAppender) {
            RollingFileAppender rollingFileAppender = (RollingFileAppender)appender;
            return new File(rollingFileAppender.getFile()).getParent();
        }
        SiftingAppender siftingAppender = (SiftingAppender)appender;
        FileAppender tempFileAppender = (FileAppender)siftingAppender.getAppenderTracker().getOrCreate("temp", 0L);
        File file = new File(tempFileAppender.getFile());
        String taskLogsFolder = file.getParent();
        tempFileAppender.stop();
        FileUtils.deleteQuietly((File)file);
        return taskLogsFolder;
    }
}

