/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.util;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.p2.internal.exception.AttributeParsingException;
import com.sonatype.nexus.repository.p2.internal.util.AttributesParserFeatureXml;
import com.sonatype.nexus.repository.p2.internal.util.AttributesParserManifest;
import com.sonatype.nexus.repository.p2.metadata.P2Attributes;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.InputStreamSupplier;

@Named
public class P2TempBlobUtils
extends ComponentSupport {
    private final AttributesParserFeatureXml featureXmlParser;
    private final AttributesParserManifest manifestParser;

    @Inject
    public P2TempBlobUtils(AttributesParserFeatureXml featureXmlParser, AttributesParserManifest manifestParser) {
        this.featureXmlParser = (AttributesParserFeatureXml)Preconditions.checkNotNull((Object)featureXmlParser);
        this.manifestParser = (AttributesParserManifest)Preconditions.checkNotNull((Object)manifestParser);
    }

    public Optional<P2Attributes> loadAttributesFrom(InputStreamSupplier inputSupplier, String extension) throws IOException {
        Preconditions.checkNotNull((Object)extension);
        try {
            P2Attributes p2Attributes = this.featureXmlParser.getAttributesFromBlob(inputSupplier, extension);
            if (p2Attributes.isEmpty()) {
                p2Attributes = this.manifestParser.getAttributesFromBlob(inputSupplier, extension);
            }
            return Optional.of(p2Attributes);
        }
        catch (AttributeParsingException ex) {
            this.log.warn("Could not get attributes from feature.xml due to following exception: {}", (Object)ex.getMessage());
            return Optional.empty();
        }
    }

    public P2Attributes mergeAttributesFromTempBlob(InputStreamSupplier inputSupplier, P2Attributes sourceP2Attributes) throws IOException {
        Preconditions.checkNotNull((Object)sourceP2Attributes.getExtension());
        return this.loadAttributesFrom(inputSupplier, sourceP2Attributes.getExtension()).filter(jarP2Attributes -> !jarP2Attributes.isEmpty()).map(jarP2Attributes -> P2Attributes.builder().merge(sourceP2Attributes, (P2Attributes)jarP2Attributes).build()).orElse(sourceP2Attributes);
    }
}

