/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.orient.upgrade.tasks;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.sonatype.nexus.repository.p2.AssetKind;
import com.sonatype.nexus.repository.p2.P2Format;
import com.sonatype.nexus.repository.p2.internal.metadata.CompositeRepositoryRewriter;
import com.sonatype.nexus.repository.p2.internal.proxy.StreamCopier;
import com.sonatype.nexus.repository.p2.orient.P2Facet;
import com.sonatype.nexus.repository.p2.orient.internal.OrientP2Facet;
import com.sonatype.nexus.repository.p2.orient.upgrade.LegacyPathUtil;
import com.sonatype.nexus.repository.p2.orient.upgrade.P2Upgrade_1_2;
import com.sonatype.nexus.repository.p2.util.P2PathUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.mime.ContentValidator;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketStore;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.types.ProxyType;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.TaskSupport;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class P2RewriteCompositeMetadataTask
extends TaskSupport
implements Cancelable {
    private final Path markerFile;
    private final RepositoryManager repositoryManager;
    private final BucketStore bucketStore;
    private final ContentValidator contentValidator;
    private final TaskScheduler taskScheduler;

    @Inject
    public P2RewriteCompositeMetadataTask(ApplicationDirectories directories, BucketStore bucketStore, RepositoryManager repositoryManager, TaskScheduler taskScheduler, ContentValidator contentValidator) {
        this.markerFile = new File(directories.getWorkDirectory("db"), P2Upgrade_1_2.MARKER_FILE).toPath();
        this.bucketStore = (BucketStore)Preconditions.checkNotNull((Object)bucketStore);
        this.contentValidator = (ContentValidator)Preconditions.checkNotNull((Object)contentValidator);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
    }

    protected Object execute() throws Exception {
        List<Repository> repositories = Streams.stream((Iterable)this.repositoryManager.browse()).peek(r -> this.log.debug("Looking at repository: {}", r)).filter(r -> r.getFormat() instanceof P2Format).peek(r -> this.log.debug("Looking at p2 repository: {}", r)).filter(r -> r.getType() instanceof ProxyType).peek(r -> this.log.debug("Found p2 proxy repository: {}", r)).collect(Collectors.toList());
        if (!repositories.isEmpty()) {
            Iterable<Asset> compositeAssets = this.rewriteLegacyAssets(repositories);
            CancelableHelper.checkCancellation();
            compositeAssets.forEach(asset -> {
                Optional<Repository> optRepository = this.getRepositoryForBucketId(asset.bucketId());
                if (!optRepository.isPresent()) {
                    this.log.warn("Unable to locate repository for asset {}", (Object)EntityHelper.id((Entity)asset));
                    return;
                }
                Repository repository = optRepository.get();
                UnitOfWork.begin((Supplier)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier());
                try {
                    this.rewriteAsset(repository, (Asset)asset);
                }
                finally {
                    UnitOfWork.end();
                }
            });
            this.rebuildBrowse(repositories);
        }
        if (Files.exists(this.markerFile, new LinkOption[0])) {
            Files.delete(this.markerFile);
        }
        return null;
    }

    private Iterable<Asset> rewriteLegacyAssets(List<Repository> repositories) {
        this.log.info("Rewriting legacy assets in p2 proxy repository: {}", repositories);
        return (Iterable)Transactional.operation.withDb(((StorageFacet)repositories.get(0).facet(StorageFacet.class)).txSupplier()).call(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            return tx.findAssets("attributes.p2.asset_kind IN :kinds", Collections.singletonMap("kinds", Arrays.asList(AssetKind.COMPOSITE_ARTIFACTS, AssetKind.COMPOSITE_CONTENT)), (Iterable)repositories, null);
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TransactionalStoreBlob
    protected void rewriteAsset(Repository repository, Asset site) {
        this.log.debug("Rewriting {} in {}", (Object)site.name(), (Object)repository.getName());
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        boolean isRoot = !site.name().contains("/");
        URI baseUri = isRoot ? this.getRepositoryUri(repository) : URI.create((String)site.formatAttributes().get("remote_url", String.class));
        try {
            Content content = this.getContent(repository, site);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            Throwable throwable = null;
            Object var9_11 = null;
            try (InputStream in = content.openInputStream();){
                IOUtils.copy((InputStream)in, (OutputStream)buffer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                } else {
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ByteArrayInputStream in = new ByteArrayInputStream(buffer.toByteArray());
            buffer.reset();
            String mimeType = this.contentValidator.determineContentType(false, () -> in, null, site.name(), content.getContentType());
            in.reset();
            CompositeRepositoryRewriter rewriter = new CompositeRepositoryRewriter(baseUri, isRoot, LegacyPathUtil::unescapePathToUri);
            String internalFilename = P2PathUtils.getAssetKind(site.name()) == AssetKind.COMPOSITE_ARTIFACTS ? "compositeArtifacts.xml" : "compositeContent.xml";
            StreamCopier.copierFor(mimeType, internalFilename, in, buffer).process(rewriter);
            Throwable throwable3 = null;
            Object var13_17 = null;
            try {
                ByteArrayInputStream rewritten = new ByteArrayInputStream(buffer.toByteArray());
                try {
                    try (TempBlob metadataContent = storageFacet.createTempBlob((InputStream)rewritten, OrientP2Facet.HASH_ALGORITHMS);){
                        site.formatAttributes().set("child_urls", rewriter.getUrls());
                        ((P2Facet)repository.facet(P2Facet.class)).saveAsset((StorageTx)UnitOfWork.currentTx(), site, metadataContent, (Payload)content);
                    }
                    if (rewritten == null) return;
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    if (rewritten == null) throw throwable3;
                    rewritten.close();
                    throw throwable3;
                }
                rewritten.close();
                return;
            }
            catch (Throwable throwable5) {
                if (throwable3 == null) {
                    throwable3 = throwable5;
                    throw throwable3;
                } else {
                    if (throwable3 == throwable5) throw throwable3;
                    throwable3.addSuppressed(throwable5);
                }
                throw throwable3;
            }
        }
        catch (IOException e) {
            this.log.error("Failed to migrate {} in {}", new Object[]{site.name(), repository.getName(), e});
        }
    }

    @TransactionalTouchBlob
    protected Content getContent(Repository repository, Asset asset) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return ((P2Facet)repository.facet(P2Facet.class)).toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    private URI getRepositoryUri(Repository repository) {
        URI uri = ((ProxyFacet)repository.facet(ProxyFacet.class)).getRemoteUrl();
        String uriString = uri.toString();
        if (uri.toString().endsWith("/")) {
            return uri;
        }
        return URI.create(String.valueOf(uriString) + '/');
    }

    private Optional<Repository> getRepositoryForBucketId(EntityId bucketId) {
        return Optional.ofNullable(this.bucketStore.getById(bucketId)).map(Bucket::getRepositoryName).map(arg_0 -> ((RepositoryManager)this.repositoryManager).get(arg_0));
    }

    public String getMessage() {
        return "Rewrite p2 composite site metadata";
    }

    private void rebuildBrowse(List<Repository> repositories) {
        String repositoryNames = repositories.stream().map(Repository::getName).collect(Collectors.joining(","));
        boolean existingTask = this.taskScheduler.findAndSubmit("create.browse.nodes", (Map)ImmutableMap.of((Object)"repositoryName", (Object)repositoryNames));
        if (!existingTask) {
            TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("create.browse.nodes");
            configuration.setString("repositoryName", repositoryNames);
            configuration.setName("Rebuild repository browse tree - (" + repositoryNames + ")");
            this.taskScheduler.submit(configuration);
        }
    }
}

