/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.orient.upgrade;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.sonatype.nexus.repository.p2.AssetKind;
import com.sonatype.nexus.repository.p2.internal.metadata.UriToSiteHashUtil;
import com.sonatype.nexus.repository.p2.orient.upgrade.AbstractP2Upgrade;
import com.sonatype.nexus.repository.p2.orient.upgrade.LegacyPathUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.common.upgrade.Dependencies;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;

@Named
@Singleton
@Upgrades(model="p2", from="1.1", to="1.2")
@Dependencies(value={@DependsOn(model="component", version="1.14", checkpoint=true), @DependsOn(model="config", version="1.8", checkpoint=true)})
public class P2Upgrade_1_2
extends AbstractP2Upgrade {
    private static final String P_NAME = "name";
    private static final String SELECT_BY_ASSET_KIND = "SELECT FROM asset WHERE bucket = ? AND attributes.p2.asset_kind IN ?";
    private static final String SELECT_NESTED_ASSETS = "SELECT FROM asset WHERE bucket = ? AND (name like 'http/%' OR name like 'https/%')";
    private static final String SELECT_REPOSITORY_URL = "SELECT attributes.proxy.remoteUrl FROM repository WHERE repository_name = ?";
    private static final String UPDATE_ASSET_KIND = "update asset set attributes.p2.asset_kind = ? where attributes.p2.asset_kind in ?";
    public static final String MARKER_FILE = String.valueOf(P2Upgrade_1_2.class.getSimpleName()) + ".marker";
    private final Pattern metadataPattern = Pattern.compile("^(?<url>.*\\/)(?<path>(content|artifacts|compositeContent|compositeArtifacts)\\.(jar|xml|xml\\.xz))$");
    private final Pattern bundlePattern = Pattern.compile("^(?<url>.*\\/)(?<path>(features|binary|plugins)\\/(.*))$");
    private Path markerFile;

    @Inject
    public P2Upgrade_1_2(@Named(value="config") Provider<DatabaseInstance> configDatabaseInstance, @Named(value="component") Provider<DatabaseInstance> componentDatabaseInstance, ApplicationDirectories directories) {
        super(configDatabaseInstance, componentDatabaseInstance);
        this.markerFile = new File(directories.getWorkDirectory("db"), MARKER_FILE).toPath();
    }

    public void apply() throws IOException {
        if (P2Upgrade_1_2.hasSchemaClass((Provider)this.configDatabaseInstance, (String)"repository") && P2Upgrade_1_2.hasSchemaClass((Provider)this.componentDatabaseInstance, (String)"asset")) {
            List<String> p2RepositoryNames = this.getP2RepositoryNames();
            if (!p2RepositoryNames.isEmpty()) {
                this.updateAssetKinds();
                p2RepositoryNames.forEach(this::updateNestedAssets);
                p2RepositoryNames.forEach(this::updateRootMetadata);
            }
            if (!Files.exists(this.markerFile, new LinkOption[0])) {
                Files.createFile(this.markerFile, new FileAttribute[0]);
            }
        }
    }

    private void updateNestedAssets(String repositoryName) {
        this.log.debug("Update nested assets in {}", (Object)repositoryName);
        DatabaseUpgradeSupport.withDatabase((Provider)this.componentDatabaseInstance, db -> this.bucketFor((ODatabaseDocumentTx)db, repositoryName).ifPresent(bucket -> {
            List assets = db.query((OQuery)new OSQLSynchQuery(SELECT_NESTED_ASSETS), new Object[]{bucket.getIdentity()});
            HashMap<String, String> pathToSite = new HashMap<String, String>();
            int count = 0;
            for (ODocument doc : assets) {
                String name = (String)doc.field(P_NAME);
                this.log.trace("Updating {}", (Object)P_NAME);
                Matcher metadataMatcher = this.metadataPattern.matcher(name);
                Matcher bundleMatcher = this.bundlePattern.matcher(name);
                if (!metadataMatcher.matches() && !bundleMatcher.matches()) {
                    this.log.warn("Skipping unknown asset: {}", (Object)name);
                    continue;
                }
                Matcher match = metadataMatcher.matches() ? metadataMatcher : bundleMatcher;
                String url = LegacyPathUtil.unescapePathToUri(match.group("url"));
                String path = match.group("path");
                String siteHash = pathToSite.computeIfAbsent(url, UriToSiteHashUtil::map);
                this.log.trace("url:'{}' path:'{}' siteHash:'{}'", new Object[]{url, path, siteHash});
                doc.field(P_NAME, (Object)(String.valueOf(siteHash) + '/' + path));
                if (metadataMatcher.matches()) {
                    Map attributes = (Map)doc.field("attributes", OType.EMBEDDEDMAP);
                    Map p2Attributes = (Map)attributes.computeIfAbsent("p2", n -> new HashMap());
                    p2Attributes.put("remote_site_hash", siteHash);
                    p2Attributes.put("remote_url", String.valueOf(url) + path);
                    doc.field("attributes", (Object)attributes, new OType[]{OType.EMBEDDEDMAP});
                }
                db.save((ORecord)doc);
                ++count;
            }
            if (count > 0) {
                this.log.info("Updated {} p2 asset(s) in repository {}: ", (Object)count, (Object)repositoryName);
            }
        }));
    }

    private void updateRootMetadata(String repositoryName) {
        this.log.debug("Updating attributes for root composites in {}", (Object)repositoryName);
        String repositoryUrl = this.getRepositoryUrl(repositoryName);
        if (Strings2.isBlank((String)repositoryUrl)) {
            this.log.warn("Skipping {} unable to determine repository url", (Object)repositoryName);
            return;
        }
        DatabaseUpgradeSupport.withDatabase((Provider)this.componentDatabaseInstance, db -> this.bucketFor((ODatabaseDocumentTx)db, repositoryName).ifPresent(bucket -> {
            List assets = db.query((OQuery)new OSQLSynchQuery(SELECT_BY_ASSET_KIND), new Object[]{bucket.getIdentity(), Arrays.asList(AssetKind.COMPOSITE_ARTIFACTS.toString(), AssetKind.COMPOSITE_CONTENT.toString(), AssetKind.ARTIFACTS_METADATA.toString(), AssetKind.CONTENT_METADATA.toString())});
            int count = 0;
            for (ODocument doc : assets) {
                String path = (String)doc.field(P_NAME);
                Map attributes = (Map)doc.field("attributes", OType.EMBEDDEDMAP);
                Map p2Attributes = (Map)attributes.computeIfAbsent("p2", n -> new HashMap());
                p2Attributes.put("remote_url", String.valueOf(repositoryUrl) + path);
                doc.field("attributes", (Object)attributes, new OType[]{OType.EMBEDDEDMAP});
                db.save((ORecord)doc);
                ++count;
            }
            if (count > 0) {
                this.log.info("Updated {} p2 asset(s) names in repository {}: ", (Object)count, (Object)repositoryName);
            }
        }));
    }

    private String getRepositoryUrl(String repositoryName) {
        String[] repositoryUrl = new String[1];
        DatabaseUpgradeSupport.withDatabase((Provider)this.configDatabaseInstance, db -> {
            List results = db.query((OQuery)new OSQLSynchQuery(SELECT_REPOSITORY_URL), new Object[]{repositoryName}).stream().map(doc -> (String)doc.field("attributes")).collect(Collectors.toList());
            if (results.isEmpty()) {
                return;
            }
            stringArray[0] = (String)results.get(0);
            if (!repositoryUrl[0].endsWith("/")) {
                stringArray[0] = String.valueOf(repositoryUrl[0]) + '/';
            }
        });
        return repositoryUrl[0];
    }

    private void updateAssetKinds() {
        this.updateAssetKind(AssetKind.ARTIFACTS_METADATA, Arrays.asList("ARTIFACT_JAR", "ARTIFACT_XML", "ARTIFACT_XML_XZ"));
        this.updateAssetKind(AssetKind.CONTENT_METADATA, Arrays.asList("CONTENT_JAR", "CONTENT_XML", "CONTENT_XML_XZ"));
        this.updateAssetKind(AssetKind.COMPOSITE_ARTIFACTS, Arrays.asList("COMPOSITE_ARTIFACTS_JAR", "COMPOSITE_ARTIFACTS_XML"));
        this.updateAssetKind(AssetKind.COMPOSITE_CONTENT, Arrays.asList("COMPOSITE_CONTENT_JAR", "COMPOSITE_CONTENT_XML"));
        this.updateAssetKind(AssetKind.BINARY_BUNDLE, Arrays.asList("COMPONENT_BINARY"));
        this.updateAssetKind(AssetKind.BUNDLE, Arrays.asList("COMPONENT_PLUGINS", "COMPONENT_FEATURES"));
    }

    private void updateAssetKind(AssetKind kind, List<String> oldKinds) {
        OCommandSQL updateAssetCommand = new OCommandSQL(UPDATE_ASSET_KIND);
        DatabaseUpgradeSupport.withDatabase((Provider)this.componentDatabaseInstance, db -> db.command((OCommandRequest)updateAssetCommand).execute(new Object[]{kind.toString(), oldKinds}));
    }
}

