/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.orient.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Provider;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;

abstract class AbstractP2Upgrade
extends DatabaseUpgradeSupport {
    private static final String SELECT_P2_REPOSITORIES = "select from repository where recipe_name = 'p2-proxy'";
    private static final String P_REPOSITORY_NAME = "repository_name";
    private static final String C_BROWSE_NODE = "browse_node";
    private static final String BROWSE_NODE_CLASS = new OClassNameBuilder().type("browse_node").build();
    private static final String DELETE_BROWSE_NODE_FROM_REPOSITORIES = String.format("delete from %s where repository_name in ?", BROWSE_NODE_CLASS);
    private static final String I_REPOSITORY_NAME = new OIndexNameBuilder().type("bucket").property("repository_name").build();
    protected static final String ASSET_CLASS_NAME = "asset";
    protected final Provider<DatabaseInstance> configDatabaseInstance;
    protected final Provider<DatabaseInstance> componentDatabaseInstance;

    protected AbstractP2Upgrade(Provider<DatabaseInstance> configDatabaseInstance, Provider<DatabaseInstance> componentDatabaseInstance) {
        this.configDatabaseInstance = (Provider)Preconditions.checkNotNull(configDatabaseInstance);
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    protected List<String> getP2RepositoryNames() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
            return db.query((OQuery)new OSQLSynchQuery(SELECT_P2_REPOSITORIES), new Object[0]).stream().map(d -> (String)d.field(P_REPOSITORY_NAME)).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected Optional<OIdentifiable> bucketFor(ODatabaseDocumentTx db, String repositoryName) {
        OIndex bucketIdx = db.getMetadata().getIndexManager().getIndex(I_REPOSITORY_NAME);
        OIdentifiable bucket = (OIdentifiable)bucketIdx.get((Object)repositoryName);
        if (bucket == null) {
            this.log.warn("Unable to find bucket for {}", (Object)repositoryName);
        }
        return Optional.ofNullable(bucket);
    }

    protected void deleteBrowseNodes(List<String> p2RepositoryNames) {
        this.log.info("Deleting browse_node data from p2 repositories to be rebuilt ({}).", p2RepositoryNames);
        DatabaseUpgradeSupport.withDatabaseAndClass(this.componentDatabaseInstance, (String)C_BROWSE_NODE, (db, type) -> {
            OSchemaProxy schema = db.getMetadata().getSchema();
            if (schema.existsClass(C_BROWSE_NODE)) {
                db.command((OCommandRequest)new OCommandSQL(DELETE_BROWSE_NODE_FROM_REPOSITORIES)).execute(new Object[]{p2RepositoryNames});
            }
        });
    }
}

