/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.orient.internal.proxy;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import com.sonatype.nexus.repository.p2.AssetKind;
import com.sonatype.nexus.repository.p2.internal.metadata.CompositeRepositoryRewriter;
import com.sonatype.nexus.repository.p2.internal.metadata.RemoveMirrorTransformer;
import com.sonatype.nexus.repository.p2.internal.metadata.UriToSiteHashUtil;
import com.sonatype.nexus.repository.p2.internal.metadata.XmlTransformer;
import com.sonatype.nexus.repository.p2.internal.proxy.StreamCopier;
import com.sonatype.nexus.repository.p2.metadata.P2Attributes;
import com.sonatype.nexus.repository.p2.orient.P2Facet;
import com.sonatype.nexus.repository.p2.orient.internal.OrientP2Facet;
import com.sonatype.nexus.repository.p2.util.P2PathUtils;
import com.sonatype.nexus.repository.p2.util.P2TempBlobUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.mime.ContentValidator;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientP2ProxyFacet
extends ProxyFacetSupport {
    public static final String REMOTE_URL = "remote_url";
    public static final String REMOTE_HASH = "remote_site_hash";
    public static final String MIRRORS_URL = "mirrors_url";
    public static final String CHILD_URLS = "child_urls";
    private final P2TempBlobUtils p2TempBlobUtils;
    private final ContentValidator contentValidator;

    @Inject
    public OrientP2ProxyFacet(P2TempBlobUtils p2TempBlobUtils, ContentValidator contentValidator) {
        this.p2TempBlobUtils = (P2TempBlobUtils)((Object)Preconditions.checkNotNull((Object)((Object)p2TempBlobUtils)));
        this.contentValidator = (ContentValidator)Preconditions.checkNotNull((Object)contentValidator);
    }

    protected void doValidate(Configuration configuration) throws Exception {
        super.doValidate(configuration);
    }

    @Nullable
    protected Content getCachedContent(Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        switch (assetKind) {
            case P2_INDEX: 
            case ARTIFACTS_METADATA: 
            case CONTENT_METADATA: 
            case COMPOSITE_ARTIFACTS: 
            case COMPOSITE_CONTENT: 
            case BUNDLE: 
            case BINARY_BUNDLE: {
                return this.getAsset(context.getRequest().getPath().substring(1));
            }
        }
        throw new IllegalStateException();
    }

    protected Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        String remoteUrl = (String)context.getAttributes().require(REMOTE_URL, String.class);
        TokenMatcher.State matcherState = P2PathUtils.matcherState(context);
        String path = context.getRequest().getPath().substring(1);
        switch (assetKind) {
            case COMPOSITE_ARTIFACTS: 
            case COMPOSITE_CONTENT: {
                return this.storeCompositeMetadata(path, content, assetKind, matcherState, remoteUrl);
            }
            case P2_INDEX: 
            case CONTENT_METADATA: {
                return this.putMetadataAsset(path, content, assetKind, remoteUrl);
            }
            case ARTIFACTS_METADATA: {
                return this.storeArtifactsMetadata(path, content, assetKind, matcherState, remoteUrl);
            }
            case BUNDLE: {
                return this.putComponent(P2PathUtils.toP2Attributes(path, matcherState), content, assetKind);
            }
            case BINARY_BUNDLE: {
                return this.putBinary(P2PathUtils.toP2AttributesBinary(path, matcherState), content);
            }
        }
        throw new IllegalStateException();
    }

    @Nullable
    protected Content fetch(Context context, Content stale) throws IOException {
        String url = this.getUrl(context);
        if (url == null) {
            return null;
        }
        return this.fetch(url, context, stale);
    }

    protected String getUrl(@Nonnull Context context) {
        String remoteUrl;
        TokenMatcher.State matcherState = P2PathUtils.matcherState(context);
        String site = (String)matcherState.getTokens().get("site");
        if (site == null) {
            String repositoryUrl = this.getRemoteUrl().toString();
            remoteUrl = URI.create(repositoryUrl.endsWith("/") ? repositoryUrl : String.valueOf(repositoryUrl) + '/').resolve(context.getRequest().getPath().substring(1)).toString();
        } else {
            String path = context.getRequest().getPath().substring(2 + site.length());
            Optional<URI> baseUri = this.findRepositoryUrl(site);
            remoteUrl = baseUri.map(b -> b.resolve(path)).map(Object::toString).orElse(null);
        }
        context.getAttributes().backing().put(REMOTE_URL, remoteUrl);
        return remoteUrl;
    }

    private Optional<URI> findRepositoryUrl(String site) {
        Iterable assets = (Iterable)Transactional.operation.withDb(((StorageFacet)this.facet(StorageFacet.class)).txSupplier()).call(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            String field = "attributes.p2.asset_kind";
            Query query = Query.builder().where(field).eq((Object)AssetKind.COMPOSITE_ARTIFACTS).or(field).eq((Object)AssetKind.COMPOSITE_CONTENT).build();
            return tx.findAssets(query, Collections.singleton(this.getRepository()));
        });
        for (Asset asset : assets) {
            List<String> urls = this.extractUris(asset);
            for (String url : urls) {
                if (!UriToSiteHashUtil.map(url).equals(site)) continue;
                return Optional.of(URI.create(url));
            }
        }
        this.log.debug("Unknown remote site: {}", (Object)site);
        return Optional.empty();
    }

    private List<String> extractUris(Asset asset) {
        return (List)asset.formatAttributes().get(CHILD_URLS, (TypeToken)new TypeToken<List<String>>(){});
    }

    @TransactionalStoreBlob
    protected Content putMetadataAsset(String path, Content content, AssetKind assetKind, String remoteUrl) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob metadataContent = storageFacet.createTempBlob(content.openInputStream(), OrientP2Facet.HASH_ALGORITHMS);){
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Bucket bucket = tx.findBucket(this.getRepository());
            Asset asset = ((P2Facet)this.facet(P2Facet.class)).findAsset(tx, bucket, path);
            if (asset == null) {
                asset = tx.createAsset(bucket, this.getRepository().getFormat());
                asset.name(path);
                asset.formatAttributes().set("asset_kind", (Object)assetKind.name());
                asset.formatAttributes().set(REMOTE_URL, (Object)remoteUrl);
            }
            return ((P2Facet)this.facet(P2Facet.class)).saveAsset(tx, asset, metadataContent, (Payload)content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content putBinary(P2Attributes p2attributes, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content.openInputStream(), OrientP2Facet.HASH_ALGORITHMS);){
            return this.doPutBinary(p2attributes, tempBlob, (Payload)content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutBinary(P2Attributes p2Attributes, TempBlob componentContent, Payload payload) throws IOException {
        return ((P2Facet)this.facet(P2Facet.class)).doCreateOrSaveComponent(p2Attributes, componentContent, payload, AssetKind.BINARY_BUNDLE);
    }

    @TransactionalStoreBlob
    protected Content putComponent(P2Attributes p2Attributes, Content content, AssetKind assetKind) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content.openInputStream(), OrientP2Facet.HASH_ALGORITHMS);){
            return this.doPutComponent(p2Attributes, tempBlob, (Payload)content, assetKind);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content doPutComponent(P2Attributes p2Attributes, TempBlob componentContent, Payload payload, AssetKind assetKind) throws IOException {
        P2Attributes mergedP2Attributes = this.p2TempBlobUtils.mergeAttributesFromTempBlob((InputStreamSupplier)componentContent, p2Attributes);
        return ((P2Facet)this.facet(P2Facet.class)).doCreateOrSaveComponent(mergedP2Attributes, componentContent, payload, assetKind);
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) {
        this.setCacheInfo(content, cacheInfo);
    }

    @TransactionalTouchMetadata
    public void setCacheInfo(Content content, CacheInfo cacheInfo) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)tx.findBucket(this.getRepository()), (Content)content);
        if (asset == null) {
            this.log.debug("Attempting to set cache info for non-existent P2 asset {}", content.getAttributes().require(Asset.class));
            return;
        }
        this.log.debug("Updating cacheInfo of {} to {}", (Object)asset, (Object)cacheInfo);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)cacheInfo);
        tx.saveAsset(asset);
    }

    @TransactionalTouchBlob
    protected Content getAsset(String name) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = ((P2Facet)this.facet(P2Facet.class)).findAsset(tx, tx.findBucket(this.getRepository()), name);
        if (asset == null) {
            return null;
        }
        if (asset.markAsDownloaded()) {
            tx.saveAsset(asset);
        }
        return ((P2Facet)this.facet(P2Facet.class)).toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    private Content storeCompositeMetadata(String assetPath, Content content, AssetKind assetKind, TokenMatcher.State matcherState, String remoteUrl) throws IOException {
        String site = this.getSiteHash(matcherState);
        String filename = AssetKind.COMPOSITE_ARTIFACTS == assetKind ? "compositeArtifacts.xml" : "compositeContent.xml";
        URI baseUri = URI.create(remoteUrl);
        CompositeRepositoryRewriter rewriter = new CompositeRepositoryRewriter(baseUri, site == null);
        Consumer<Asset> assetModifier = asset -> {
            Object object = asset.formatAttributes().set(CHILD_URLS, rewriter.getUrls());
        };
        return this.rewriteAndStoreMetadata(assetPath, content, filename, assetKind, matcherState, remoteUrl, rewriter, assetModifier);
    }

    private Content storeArtifactsMetadata(String assetPath, Content content, AssetKind assetKind, TokenMatcher.State matcherState, String remoteUrl) throws IOException {
        RemoveMirrorTransformer removeMirrorTransformer = new RemoveMirrorTransformer();
        Consumer<Asset> assetModifier = asset -> {
            Optional<String> mirrorUrl = removeMirrorTransformer.getMirrorsUrl();
            mirrorUrl.ifPresent(s -> {
                Object object = asset.formatAttributes().set(MIRRORS_URL, s);
            });
        };
        return this.rewriteAndStoreMetadata(assetPath, content, "artifacts.xml", assetKind, matcherState, remoteUrl, removeMirrorTransformer, assetModifier);
    }

    /*
     * Loose catch block
     */
    @TransactionalStoreBlob
    protected Content rewriteAndStoreMetadata(String assetPath, Content content, String internalFilename, AssetKind assetKind, TokenMatcher.State matcherState, String remoteUrl, XmlTransformer transformer, Consumer<Asset> assetModifier) throws IOException {
        String siteHash = this.getSiteHash(matcherState);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var12_13 = null;
        try (InputStream in = content.openInputStream();){
            IOUtils.copy((InputStream)in, (OutputStream)buffer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(buffer.toByteArray());
        buffer.reset();
        String mimeType = this.contentValidator.determineContentType(false, () -> in, null, assetPath, content.getContentType());
        in.reset();
        StreamCopier.copierFor(mimeType, internalFilename, in, buffer).process(transformer);
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable3 = null;
        Object var15_18 = null;
        try {
            Content content2;
            TempBlob metadataContent;
            ByteArrayInputStream rewritten;
            block27: {
                block26: {
                    rewritten = new ByteArrayInputStream(buffer.toByteArray());
                    metadataContent = storageFacet.createTempBlob((InputStream)rewritten, OrientP2Facet.HASH_ALGORITHMS);
                    StorageTx tx = (StorageTx)UnitOfWork.currentTx();
                    Bucket bucket = tx.findBucket(this.getRepository());
                    Asset asset = ((P2Facet)this.facet(P2Facet.class)).findAsset(tx, bucket, assetPath);
                    if (asset == null) {
                        asset = tx.createAsset(bucket, this.getRepository().getFormat());
                        asset.name(assetPath);
                        asset.formatAttributes().set("asset_kind", (Object)assetKind.name());
                    }
                    asset.formatAttributes().set(REMOTE_URL, (Object)remoteUrl);
                    asset.formatAttributes().set(REMOTE_HASH, (Object)siteHash);
                    assetModifier.accept(asset);
                    content2 = ((P2Facet)this.facet(P2Facet.class)).saveAsset(tx, asset, metadataContent, (Payload)content);
                    if (metadataContent == null) break block26;
                    metadataContent.close();
                }
                if (rewritten == null) break block27;
                rewritten.close();
            }
            return content2;
            {
                catch (Throwable throwable4) {
                    try {
                        if (metadataContent != null) {
                            metadataContent.close();
                        }
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (throwable3 == null) {
                            throwable3 = throwable5;
                        } else if (throwable3 != throwable5) {
                            throwable3.addSuppressed(throwable5);
                        }
                        if (rewritten != null) {
                            rewritten.close();
                        }
                        throw throwable3;
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable3 == null) {
                throwable3 = throwable6;
            } else if (throwable3 != throwable6) {
                throwable3.addSuppressed(throwable6);
            }
            throw throwable3;
        }
    }

    private String getSiteHash(TokenMatcher.State matcherState) {
        String site = (String)matcherState.getTokens().get("site");
        if (site == null) {
            return null;
        }
        return UriToSiteHashUtil.map(this.getRemoteUrl());
    }
}

