/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.orient.internal.proxy;

import com.google.common.collect.Streams;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Named;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.manager.RepositoryUpdatedEvent;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Named
@Facet.Exposed
public class OrientP2ProxyCacheInvalidatorFacet
extends FacetSupport {
    @Subscribe
    @AllowConcurrentEvents
    protected void on(RepositoryUpdatedEvent event) {
        Repository repository = event.getRepository();
        if (!repository.getName().equals(this.getRepository().getName())) {
            return;
        }
        if (!Objects.equals(OrientP2ProxyCacheInvalidatorFacet.getRemoteUrl(repository.getConfiguration()), OrientP2ProxyCacheInvalidatorFacet.getRemoteUrl(event.getOldConfiguration()))) {
            this.log.info("URL changed for p2 repository: {}", (Object)this.getRepository().getName());
            this.deleteAssets();
        }
    }

    public void deleteAssets() {
        Repository repository = this.getRepository();
        this.log.info("Removing cached assets in p2 proxy repository: {}", (Object)repository);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var4_5 = null;
        try (StorageTx tx = (StorageTx)storageFacet.txSupplier().get();){
            tx.begin();
            Bucket bucket = tx.findBucket(repository);
            Streams.stream((Iterable)tx.browseAssets(bucket)).peek(a -> this.log.debug("Evaluating asset: {}", (Object)a.name())).forEach(a -> {
                CancelableHelper.checkCancellation();
                this.log.debug("Deleting asset: {}", (Object)a.name());
                tx.deleteAsset(a);
            });
            Streams.stream((Iterable)tx.browseComponents(bucket)).peek(c -> this.log.debug("Evaluating asset: {}", (Object)c.name())).forEach(c -> {
                CancelableHelper.checkCancellation();
                this.log.debug("Deleting component: {}", (Object)c.name());
                tx.deleteComponent(c);
            });
            tx.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Object getRemoteUrl(Configuration configuration) {
        return Optional.ofNullable((Map)configuration.getAttributes().get("proxy")).map(proxy -> proxy.get("remoteUrl")).orElse(null);
    }
}

