/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.orient.internal;

import com.sonatype.nexus.repository.p2.AssetKind;
import com.sonatype.nexus.repository.p2.metadata.P2Attributes;
import com.sonatype.nexus.repository.p2.orient.P2Facet;
import com.sonatype.nexus.repository.p2.orient.P2RestoreFacet;
import com.sonatype.nexus.repository.p2.orient.internal.OrientP2Facet;
import com.sonatype.nexus.repository.p2.util.P2PathUtils;
import com.sonatype.nexus.repository.p2.util.P2TempBlobUtils;
import java.io.IOException;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.cache.CacheControllerHolder;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Priority(value=0x7FFFFFFF)
public class OrientP2RestoreFacet
extends FacetSupport
implements P2RestoreFacet {
    private final P2TempBlobUtils p2TempBlobUtils;

    @Inject
    public OrientP2RestoreFacet(P2TempBlobUtils p2TempBlobUtils) {
        this.p2TempBlobUtils = p2TempBlobUtils;
    }

    @Override
    @TransactionalTouchBlob
    public void restore(AssetBlob assetBlob, String path) {
        Asset asset;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        P2Facet facet = (P2Facet)this.facet(P2Facet.class);
        if (this.componentRequired(path)) {
            P2Attributes attributes = P2Attributes.builder().build();
            try {
                attributes = this.getComponentAttributes(assetBlob.getBlob(), path);
            }
            catch (IOException iOException) {
                this.log.error("Exception of extracting components attributes from blob {}", (Object)assetBlob);
            }
            Component component = facet.findOrCreateComponent(tx, attributes);
            asset = facet.findOrCreateAsset(tx, component, path, attributes);
        } else {
            asset = facet.findOrCreateAsset(tx, path);
        }
        tx.attachBlob(asset, assetBlob);
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)new AttributesMap()));
        tx.saveAsset(asset);
    }

    @Override
    @TransactionalTouchBlob
    public boolean assetExists(String path) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return tx.findAssetWithProperty("name", (Object)path, tx.findBucket(this.getRepository())) != null;
    }

    @Override
    public boolean componentRequired(String name) {
        AssetKind assetKind = ((P2Facet)this.facet(P2Facet.class)).getAssetKind(name);
        return CacheControllerHolder.CONTENT.equals((Object)assetKind.getCacheType());
    }

    @Override
    public Query getComponentQuery(Blob blob, String blobName, String blobStoreName) throws IOException {
        P2Attributes attributes = this.getComponentAttributes(blob, blobName);
        return Query.builder().where("name").eq((Object)attributes.getComponentName()).and("version").eq((Object)attributes.getComponentVersion()).build();
    }

    private P2Attributes getComponentAttributes(Blob blob, String blobName) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = ((StorageFacet)this.facet(StorageFacet.class)).createTempBlob((Payload)new BlobPayload(blob, null), OrientP2Facet.HASH_ALGORITHMS);){
            return P2PathUtils.getAttributesFromBlob(this.p2TempBlobUtils, (InputStreamSupplier)tempBlob, blobName);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

